% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOServiceIdentification.R
\docType{class}
\name{ISOSRVServiceIdentification19139}
\alias{ISOSRVServiceIdentification19139}
\title{ISOSRVServiceIdentification19139}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO SRV ServiceIdentification in ISO 19139
}
\description{
ISOSRVServiceIdentification19139

ISOSRVServiceIdentification19139
}
\keyword{ISO}
\keyword{identification}
\keyword{service}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOIdentification]{geometa::ISOIdentification}} -> \code{\link[geometa:ISOIdentification19139]{geometa::ISOIdentification19139}} -> \code{\link[geometa:ISOServiceIdentification19139]{geometa::ISOServiceIdentification19139}} -> \code{ISOSRVServiceIdentification19139}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{serviceType}}{serviceType [1..1]: ISOGenericName}

\item{\code{serviceTypeVersion}}{serviceTypeVersion [0..*]: character}

\item{\code{accessProperties}}{accessProperties [0..1]: ISOStandardOrderProcess}

\item{\code{restrictions}}{restrictions [0..1]: ISOConstraints}

\item{\code{keywords}}{keywords [0..*]: ISOKeywords}

\item{\code{extent}}{extent [0..*]: ISOExtent}

\item{\code{coupledResource}}{coupledResource [0..*]: ISOCoupledResource}

\item{\code{couplingType}}{couplingType [1..1]: ISOCouplingType}

\item{\code{containsOperations}}{containsOperations [1..*]: ISOOperationMetadata}

\item{\code{operatesOn}}{operatesOn [0..*]: ISODataIdentification}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOSRVServiceIdentification19139-new}{\code{ISOSRVServiceIdentification19139$new()}}
\item \href{#method-ISOSRVServiceIdentification19139-setServiceType}{\code{ISOSRVServiceIdentification19139$setServiceType()}}
\item \href{#method-ISOSRVServiceIdentification19139-addServiceTypeVersion}{\code{ISOSRVServiceIdentification19139$addServiceTypeVersion()}}
\item \href{#method-ISOSRVServiceIdentification19139-delServiceTypeVersion}{\code{ISOSRVServiceIdentification19139$delServiceTypeVersion()}}
\item \href{#method-ISOSRVServiceIdentification19139-setAccessProperties}{\code{ISOSRVServiceIdentification19139$setAccessProperties()}}
\item \href{#method-ISOSRVServiceIdentification19139-setRestrictions}{\code{ISOSRVServiceIdentification19139$setRestrictions()}}
\item \href{#method-ISOSRVServiceIdentification19139-addKeywords}{\code{ISOSRVServiceIdentification19139$addKeywords()}}
\item \href{#method-ISOSRVServiceIdentification19139-delKeywords}{\code{ISOSRVServiceIdentification19139$delKeywords()}}
\item \href{#method-ISOSRVServiceIdentification19139-addExtent}{\code{ISOSRVServiceIdentification19139$addExtent()}}
\item \href{#method-ISOSRVServiceIdentification19139-delExtent}{\code{ISOSRVServiceIdentification19139$delExtent()}}
\item \href{#method-ISOSRVServiceIdentification19139-addCoupledResource}{\code{ISOSRVServiceIdentification19139$addCoupledResource()}}
\item \href{#method-ISOSRVServiceIdentification19139-delCoupledResource}{\code{ISOSRVServiceIdentification19139$delCoupledResource()}}
\item \href{#method-ISOSRVServiceIdentification19139-setCouplingType}{\code{ISOSRVServiceIdentification19139$setCouplingType()}}
\item \href{#method-ISOSRVServiceIdentification19139-addOperationMetadata}{\code{ISOSRVServiceIdentification19139$addOperationMetadata()}}
\item \href{#method-ISOSRVServiceIdentification19139-delOperationMetadata}{\code{ISOSRVServiceIdentification19139$delOperationMetadata()}}
\item \href{#method-ISOSRVServiceIdentification19139-addOperatesOn}{\code{ISOSRVServiceIdentification19139$addOperatesOn()}}
\item \href{#method-ISOSRVServiceIdentification19139-delOperatesOn}{\code{ISOSRVServiceIdentification19139$delOperatesOn()}}
\item \href{#method-ISOSRVServiceIdentification19139-clone}{\code{ISOSRVServiceIdentification19139$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addAggregateInformation"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addAggregateInformation'><code>geometa::ISOIdentification19139$addAggregateInformation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addCredit"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addCredit'><code>geometa::ISOIdentification19139$addCredit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addFormat"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addFormat'><code>geometa::ISOIdentification19139$addFormat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addGraphicOverview"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addGraphicOverview'><code>geometa::ISOIdentification19139$addGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addPointOfContact"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addPointOfContact'><code>geometa::ISOIdentification19139$addPointOfContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addResourceConstraints"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addResourceConstraints'><code>geometa::ISOIdentification19139$addResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addResourceMaintenance"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addResourceMaintenance'><code>geometa::ISOIdentification19139$addResourceMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addResourceSpecificUsage"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addResourceSpecificUsage'><code>geometa::ISOIdentification19139$addResourceSpecificUsage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="addStatus"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-addStatus'><code>geometa::ISOIdentification19139$addStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delAggregateInformation"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delAggregateInformation'><code>geometa::ISOIdentification19139$delAggregateInformation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delCredit"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delCredit'><code>geometa::ISOIdentification19139$delCredit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delFormat"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delFormat'><code>geometa::ISOIdentification19139$delFormat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delGraphicOverview"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delGraphicOverview'><code>geometa::ISOIdentification19139$delGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delPointOfContact"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delPointOfContact'><code>geometa::ISOIdentification19139$delPointOfContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delResourceConstraints"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delResourceConstraints'><code>geometa::ISOIdentification19139$delResourceConstraints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delResourceMaintenance"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delResourceMaintenance'><code>geometa::ISOIdentification19139$delResourceMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delResourceSpecificUsage"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delResourceSpecificUsage'><code>geometa::ISOIdentification19139$delResourceSpecificUsage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="delStatus"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-delStatus'><code>geometa::ISOIdentification19139$delStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setAbstract"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setAbstract'><code>geometa::ISOIdentification19139$setAbstract()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setCitation"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setCitation'><code>geometa::ISOIdentification19139$setCitation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setGraphicOverview"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setGraphicOverview'><code>geometa::ISOIdentification19139$setGraphicOverview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setKeywords"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setKeywords'><code>geometa::ISOIdentification19139$setKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setPurpose"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setPurpose'><code>geometa::ISOIdentification19139$setPurpose()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOIdentification19139" data-id="setResourceMaintenance"><a href='../../geometa/html/ISOIdentification19139.html#method-ISOIdentification19139-setResourceMaintenance'><code>geometa::ISOIdentification19139$setResourceMaintenance()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-setServiceType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-setServiceType}{}}}
\subsection{Method \code{setServiceType()}}{
Set service type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$setServiceType(serviceType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serviceType}}{object of class \link{ISOLocalName}, \link{ISOScopedName} or \link{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-addServiceTypeVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-addServiceTypeVersion}{}}}
\subsection{Method \code{addServiceTypeVersion()}}{
Adds service type version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$addServiceTypeVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-delServiceTypeVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-delServiceTypeVersion}{}}}
\subsection{Method \code{delServiceTypeVersion()}}{
Deletes service type version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$delServiceTypeVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-setAccessProperties"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-setAccessProperties}{}}}
\subsection{Method \code{setAccessProperties()}}{
Set access properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$setAccessProperties(accessProperties)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accessProperties}}{object of class \link{ISOStandardOrderProcess}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-setRestrictions"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-setRestrictions}{}}}
\subsection{Method \code{setRestrictions()}}{
Set restrictions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$setRestrictions(restrictions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{restrictions}}{object of class \link{ISOConstraints}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-addKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-addKeywords}{}}}
\subsection{Method \code{addKeywords()}}{
Adds keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$addKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-delKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-delKeywords}{}}}
\subsection{Method \code{delKeywords()}}{
Deletes keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$delKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{object of class \link{ISOKeywords}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-addExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-addExtent}{}}}
\subsection{Method \code{addExtent()}}{
Adds extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$addExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-delExtent"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-delExtent}{}}}
\subsection{Method \code{delExtent()}}{
Deletes extent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$delExtent(extent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extent}}{object of class \link{ISOExtent}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-addCoupledResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-addCoupledResource}{}}}
\subsection{Method \code{addCoupledResource()}}{
Adds coupled resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$addCoupledResource(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{object of class \link{ISOCoupledResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-delCoupledResource"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-delCoupledResource}{}}}
\subsection{Method \code{delCoupledResource()}}{
Deletes coupled resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$delCoupledResource(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{object of class \link{ISOCoupledResource}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-setCouplingType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-setCouplingType}{}}}
\subsection{Method \code{setCouplingType()}}{
Set coupling type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$setCouplingType(couplingType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{couplingType}}{object of class \link{ISOCouplingType} or any \link{character}
among values returned by \code{ISOCouplingType$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-addOperationMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-addOperationMetadata}{}}}
\subsection{Method \code{addOperationMetadata()}}{
Adds operation metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$addOperationMetadata(operationMetadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{operationMetadata}}{object of class \link{ISOOperationMetadata}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-delOperationMetadata"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-delOperationMetadata}{}}}
\subsection{Method \code{delOperationMetadata()}}{
Deletes operation metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$delOperationMetadata(operationMetadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{operationMetadata}}{object of class \link{ISOOperationMetadata}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-addOperatesOn"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-addOperatesOn}{}}}
\subsection{Method \code{addOperatesOn()}}{
Adds operates on
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$addOperatesOn(dataIdentification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataIdentification}}{object of class \link{ISODataIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-delOperatesOn"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-delOperatesOn}{}}}
\subsection{Method \code{delOperatesOn()}}{
Deletes operates on
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$delOperatesOn(dataIdentification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataIdentification}}{object of class \link{ISODataIdentification}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOSRVServiceIdentification19139-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOSRVServiceIdentification19139-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOSRVServiceIdentification19139$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
