% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsearch.R
\name{tsearchn}
\alias{tsearchn}
\title{Search for the enclosing Delaunay convex hull}
\usage{
tsearchn(x, t, xi, ...)
}
\arguments{
\item{x}{An \eqn{N}-column matrix, in which each row represents a
point in \eqn{N}-dimensional space.}

\item{t}{A matrix with \eqn{N+1} columns. A row of \code{t}
contains indices into \code{x} of the vertices of an
\eqn{N}-dimensional simplex. \code{t} is usually the output of
delaunayn.}

\item{xi}{An \eqn{M}-by-\eqn{N} matrix. The rows of \code{xi}
represent \eqn{M} points in \eqn{N}-dimensional space whose
positions in the mesh are being sought.}

\item{...}{Additional arguments}
}
\value{
A list containing:
  \describe{
    \item{\code{idx}}{An \eqn{M}-long vector containing the indices
      of the row of \code{t} in which each point in \code{xi} is found.}
   \item{\code{p}}{An \eqn{M}-by-\eqn{N+1} matrix containing the
    barycentric coordinates with respect to the enclosing simplex
    of each point in \code{xi}.}}
}
\description{
For \code{t = delaunayn(x)}, where \code{x} is a set of points in \eqn{N}
dimensions, \code{tsearchn(x, t, xi)} finds the index in \code{t}
containing the points \code{xi}. For points outside the convex hull,
\code{idx} is \code{NA}. \code{tsearchn} also returns the barycentric
coordinates \code{p} of the enclosing triangles.
}
\details{
If \code{x} is \code{NA} and the \code{t} is a
\code{delaunayn} object produced by
\code{\link{delaunayn}} with the \code{full} option, then use the
Qhull library to perform the search. Please note that this is
experimental in geometry version 0.4.0 and is only partly tested
for 3D hulls, and does not yet work for hulls of 4 dimensions and
above.
}
\note{
Based on the Octave function Copyright (C) 2007-2012 David
  Bateman.
}
\seealso{
tsearch, delaunayn
}
\author{
David Sterratt
}
