% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-net.R
\name{fortify.igraph}
\alias{fortify.igraph}
\title{Function for converting an igraph object into the correct format for use with geomnet}
\usage{
\method{fortify}{igraph}(model, data = NULL, group = NULL, ...)
}
\arguments{
\item{model}{A network object of class \code{"igraph"}.}

\item{data}{NULL - not used in this function}

\item{group}{character. Used for facetting. If you wish to facet on a network variable provide the name of that variable here.}

\item{...}{not used in this function}
}
\description{
Function for converting an igraph object into the correct format for use with geomnet
}
\examples{
# class igraph (igraph, igraphdata packages)
library(igraph)
data(blood, package = "geomnet")
blood.igraph <- graph_from_data_frame(d = blood$edges, 
   directed = TRUE, vertices = unique(blood$vertices[, 1:3]))
fortify(blood.igraph)

}
