% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{soccer}
\alias{soccer}
\title{High school boys' soccer games in Iowa (undirected)}
\format{
A list of two data frames:
\itemize{
\item the edges data set consists of 11 variables of length 4484:
\itemize{
  \item sub: Integer variable with the subregion of the state the school is in (1-8)
  \item home: Factor variable containing the home team school
  \item season: Integer variable with the year the game was played
  \item week: Integer variable with the week of the season the game was played
  \item date: Factor variable containing the date the game was played
  \item away: Factor variable containing the away team school
  \item ha: Factor variable stating if the first team is the home team, away team, or neutral?
  \item result: Factor variable stating if the home team won, lost, or tied?
  \item score: Factor variable with game final score, home team first
  \item diff: Integer variable with home team score minus away team score
  \item same_div: An indicator variable that is 1 if the schools are in the same division and 0 otherwise
}
\item the vertices data set consists of two variables with information on 157 schools:
\itemize{
  \item div: Factor variable with division school is in (1, 2, or 3A)
  \item label: Factor variable with school name
}
}
}
\usage{
soccer
}
\description{
A list of two datasets, vertices and edges, containing data on boys' soccer games at Iowa high schools in the 2011-2014 seasons.
This dataset was compiled by Danny Bero (\email{bero.danny@gmail.com}).
The variables are as follows:
}
\examples{
# prep the data
soccernet <- merge(soccer$edges, soccer$vertices, by.x = "home",
                   by.y = "label", all = TRUE)
library(geomnet)
library(dplyr)
# create plot
ggplot(data = soccernet, aes(from_id = home, to_id = away)) +
  geom_net(aes(colour = div, group = div), ealpha = .25,
           layout.alg = 'fruchtermanreingold') +
  facet_wrap(~season) +
  theme_net()
}
\keyword{datasets}
