% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorph.support.code.r
\name{mshape}
\alias{mshape}
\title{Estimate mean shape for a set of aligned specimens}
\usage{
mshape(A)
}
\arguments{
\item{A}{Either a list (length n, ach p x k), A 3D array (p x k x n), or a matrix (pk X n) containing GPA-aligned coordinates for a set of specimens}
}
\description{
Estimate the mean shape for a set of aligned specimens
}
\details{
The function estimates the average landmark coordinates for a set of aligned specimens. It is assumed 
that the landmarks have previously been aligned using Generalized Procrustes Analysis (GPA) 
 [e.g., with \code{\link{gpagen}}]. This function is described in Claude (2008).
}
\examples{
data(plethodon) 
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment   

mshape(Y.gpa$coords)   #mean (consensus) configuration
}
\references{
Claude, J. 2008. Morphometrics with R. Springer, New York.
}
\author{
Julien Claude
}
\keyword{utilities}
