% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.subsets.R
\name{combine.subsets}
\alias{combine.subsets}
\title{Combine separate landmark configurations}
\usage{
combine.subsets(
  ...,
  gpa = TRUE,
  CS.sets = NULL,
  norm.CS = FALSE,
  weights = NULL
)
}
\arguments{
\item{...}{Class gpagen objects, Procrustes shape variables from class gpagen objects, or original landmarks.
As many data sets as desired can be supplied, separated by commas.  Additionally, arguments passed onto 
\code{\link{gpagen}} can be provided, but these arguments will be passed onto all GPAs performed.  Therefore,
it is recommended that GPA is performed first with \code{\link{gpagen}}, to maintain flexibility.  Naming
subsets is a good idea, as landmark names in the combined data set will take the subset name as a precursor.}

\item{gpa}{A logical argument to indicate if either (1) GPA should be performed (if original landmarks
are provided) or (2) \code{gpagen} objects are provided.  If TRUE, this function will check to see if 
the input is an object of class \code{gpagen}, and if not, perform GPA.  If FALSE, landmarks will be unchanged.
(One would choose gpa = FALSE if inputting aligned coordinates and centroid size, separately.  There might be
little reason to do this, unless one wishes to intentionally not scale configurations.)}

\item{CS.sets}{A list, array, or matrix of centroid sizes to use for scaling.  The default is NULL and should be
left so if gpa = TRUE.  If gpa = FALSE and CS.set is null, all centroid sizes become 1.0, meaning no scaling 
of configurations by relative size is performed.  If gpa = FALSE and CS.set is provided, scaling by relative 
size is performed according to the data input  (One could weight configurations via this method.).  If the 
CS.set input is a matrix, it is assumed that rows are specimens and columns correspond to the different landmark
sets.  Lists or arrays should be in the same order as the landmark sets.}

\item{norm.CS}{An option to normalize centroid size, according to the method of Dryden and Mardia (2016).  If TRUE,
centroid sizes are divided by the square root of the number of landmarks.  This may have some appeal when one
configuration is landmark-dense and another is landmark-sparse, but both correspond to structures of similar surface area
or volume.  Using this option should be done with caution, as it can make small configurations larger than large configurations,
in a relative sense.  Choosing this option will probably produce relative centroid sizes that are more equal, 
irrespective of the number of landmarks.}

\item{weights}{An option to define (positive) weights used in calculation of relative centroid sizes (Collyer et al. 2020).  Note that
this option, if not NULL, will override norm.CS, as normalizing CS is one method of weighting centroid size. Using this option 
should be done with caution, as it can make small configurations larger than large configurations,
in a relative sense.  Note that no adjustments of weights are made - the user must define the weights exactly as intended.}
}
\value{
An object of class \code{combined.set} is a list containing the following
\item{cords}{An [p x k x n] array of scaled, concatenated landmark coordinates.}
\item{CS}{A matrix of columns representing original centroid sizes of subsets,
either input or found via GPA.}
\item{GPA}{If gpa = TRUE, the gpagen results for each subset.}
\item{gpa.coords.by.set}{A list of the coordinates following GPA for each subset.}
\item{adj.coords.by.set}{A list of the coordinates of each subset, after rescaling.}
\item{points.by.set}{A vector of the number of landmarks in each subset.}
}
\description{
Combine separate landmark configurations (subsets) into one landmark set
}
\details{
This function combines landmark configurations (either landmarks requiring GPA
or Procrustes shape variables following GPA) to create a different morphological data set.  
This might be of interest, for example, if one has landmarks digitized on separate images
collected from the same organisms.  (In the examples below, configurations for heads and tails
of larval salamanders were collected separately from images taken on the same individuals.)  An
attempt is made to scale configurations by their relative centroid sizes, following the procedure in
Davis et al. (2016); i.e., landmark coordinates are multiplied by CSi/sqrt(CSi^2 + CSj^2 + ...) before 
combining them, so that resulting combinations of landmarks are scaled to unit centroid size.  This is
only possible if GPA is performed on landmarks (gpa = TRUE) or centroid sizes are provided as an 
argument.  Objects of class \code{gpagen} can be used rather than original landmarks (recommended, 
especially if curves or surface sliding semilandmarks are used, as different arguments cannot be passed onto
onto separate GPAs via this function).

The procedure of Davis et al. (2016) is an extension of the "separate subsets" method of Adams (1999)
for articulated structures.
}
\examples{
# NOT RUN
# data(larvalMorph) 
# head.gpa <- gpagen(larvalMorph$headcoords, 
#   curves = larvalMorph$head.sliders)
# tail.gpa <- gpagen(larvalMorph$tailcoords, 
 # curves = larvalMorph$tail.sliders)

# Combine original data without GPA (plot to see relative size of  
# heads and tails)

 # all.lm <- combine.subsets(head = larvalMorph$headcoords,
 # tail = larvalMorph$tailcoords, gpa = FALSE, CS.sets = NULL)
 # plotAllSpecimens((all.lm$coords))
 
 # Combine with GPA and relative centroid size
 
# comb.lm <- combine.subsets(head = head.gpa, tail = tail.gpa, gpa = TRUE)
# summary(comb.lm)

# (configurations are actual relative size)
# comb.lm$coords[,,1]

# Plot all specimens and just first specimen and color code landmarks 
# par(mfrow = c(1,2))
# plotAllSpecimens(comb.lm$coords)
# plot(comb.lm$coords[,,1], pch = 21, bg = c(rep(1,26), 
# rep(2,64)), asp = 1)

# Override relative centroid size

# comb.lm <- combine.subsets(head = head.gpa$coords, 
# tail = tail.gpa$coords, gpa = FALSE, CS.sets = NULL)
# par(mfrow = c(1,2))
# plotAllSpecimens(comb.lm$coords)
# plot(comb.lm$coords[,,1], pch = 21, bg = c(rep(1,26), 
# rep(2,64)), asp = 1)

# Note the head is as large as the tail, which is quite unnatural.

## Normalizing centroid size

# comb.lm <- combine.subsets(head = head.gpa, 
# tail = tail.gpa, gpa = TRUE, norm.CS = TRUE)
# summary(comb.lm)
# par(mfrow = c(1,2))
# plotAllSpecimens(comb.lm$coords)
# plot(comb.lm$coords[,,1], pch = 21, bg = c(rep(1,26), 
# rep(2,64)), asp = 1)
# par(mfrow = c(1,1))

# Note that the head is too large, compared to a real specimen.  
# This option focuses on average distance of points to centroid, 
# but ignores the number of landmarks.  
# Consequently,the density of landmarks in the head and tail are 
# irrelevant and the head size is inflated because of the fewer 
# landmarks in the configuration.

## Weighting centroid size

# comb.lm <- combine.subsets(head = head.gpa, 
# tail = tail.gpa, gpa = TRUE, norm.CS = FALSE, weights = c(0.3, 0.7))
# summary(comb.lm)
# par(mfrow = c(1,2))
# plotAllSpecimens(comb.lm$coords)
# plot(comb.lm$coords[,,1], pch = 21, bg = c(rep(1,26), 
# rep(2,64)), asp = 1)
# par(mfrow = c(1,1))

# Note that the head is way too small, compared to a real specimen.  
# This option allows one to dictate the relative sizes of subsets
#  as portions of the combined set.  An option like this should be 
# used with caution, but can help overcome issues caused by landmark 
# density.
}
\references{
Davis, M.A., M.R. Douglas, M.L. Collyer, & M.E. Douglas, M. E. 2016.
 Deconstructing a species-complex: geometric morphometric and molecular analyses define species in the 
 Western Rattlesnake (Crotalus viridis). PLoS one, 11(1), e0146166.

Adams, D.C. 1999. Methods for shape analysis of landmark data from articulated structures. 
 Evolutionary Ecology Research. 1:959-970.

Dryden, I.L. and K.V Mardia. 2016. Statistical shape analysis, with applications in R: Second edition.

Collyer, M.L., M.A. Davis, and D.C. Adams. 2020. Making heads or tails of combined landmark configurations in 
geometric morphometric data. Evolutionary Biology. 47:193-205.
}
\author{
Michael Collyer
}
\keyword{utilities}
