% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSVirtualTable.R
\docType{class}
\name{GSVirtualTable}
\alias{GSVirtualTable}
\title{Geoserver REST API GSVirtualTable}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer virtual table
}
\description{
Geoserver REST API GSVirtualTable
}
\section{Fields}{

\describe{
\item{\code{name}}{name}

\item{\code{sql}}{SQL statement}

\item{\code{escapeSql}}{escape SQL?}

\item{\code{keyColumn}}{key column}

\item{\code{geometry}}{geometry}

\item{\code{parameters}}{list of virtual parameters}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate a GSVirtualTable
 }
 \item{\code{decode(xml)}}{
   This method is used to decode a GSVirtualTable from XML
 }
 \item{\code{encode()}}{
   This method is used to encode a GSVirtualTable to XML
 }
 \item{\code{setName(name)}}{
   Sets the name of the virtual table
 }
 \item{\code{setSql(sql)}}{
   Sets the sql of the virtual table
 }
 \item{\code{setEscapeSql(escapeSql)}}{
   Sets the escapeSql. Default is FALSE
 }
 \item{\code{setKeyColumn(keyColumn)}}{
   Sets the keyColumn. Name of the column to be the primary key
 }
 \item{\code{setGeometry(vtg)}}{
   Sets the virtual table geometry
 }
 \item{\code{addParameter(vtp)}}{
   Adds a virtual table parameter
 }
 \item{\code{delParameter(param)}}{
   Removes a virtual table parameter.
 }
}
}

\examples{
GSVirtualTable$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{virtualTable}
