% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_point_dist.R
\name{geo_point_dist}
\alias{geo_point_dist}
\title{Distance Between Two Latitude and Longitude Points}
\usage{
geo_point_dist(coordinate_matrix, matrix = FALSE)
}
\arguments{
\item{coordinate_matrix}{A matrix of latitude and longitude columns and up to three rows of points}

\item{matrix}{Generates a matrix that shows/preseves the relationship between point combinations and the respective distance between them}
}
\value{
An input matrix with two rows returns a vector of length 1 containing the calculated distance. If the matrix argument is set to FALSE and an input matrix with three rows is given as the coordinate_matrix argument a vector of length 3 containing the calculated distances is returned. If the matrix argument is set to TRUE and an input matrix with three rows is given as the coordinate_matrix argument a 3 by 3 matrix of distances is returned.
}
\description{
Calculates the distance in kilometers between up to a combination of three latitude, longitude points
}
\examples{

# Load required packages
require(mapview)
require(sp)

# Create sample geo dataset
sample_coord <-
   matrix(
        c(
            sample(327131680:419648450, 3) / 10000000,
            sample(-1147301410:-1241938690, 3) / 10000000
        ),
        ncol = 2
    )

# Calculate distances
(gpd <- geo_point_dist(sample_coord))

# Calculate distances and preserve relationship (Useful for three input points)
(gpd <- geo_point_dist(sample_coord, matrix = TRUE))

# Create SpacialPoints object and pass to mapview for visualization
mapview(
    SpatialPoints(
        sample_coord[,c(2, 1)],
        proj4string = CRS("+proj=longlat +datum=WGS84")
    )
)


}
\seealso{
\code{\link{geo_sed}} \code{\link{geo_point_dist}}
}
\author{
Shant Sukljian
}
\keyword{circle}
\keyword{disk}
\keyword{enclosing}
\keyword{geo}
\keyword{latitude}
\keyword{longitude}
\keyword{sed}
\keyword{smallest}
