% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calCost.R
\name{new_krigGrid_for_visualisation}
\alias{new_krigGrid_for_visualisation}
\title{new_krigGrid_for_visualisation}
\usage{
new_krigGrid_for_visualisation(map, Z, numZ, solution)
}
\arguments{
\item{map}{object returned by function genMap}

\item{Z}{list of zones.}

\item{numZ}{number of the zone whose values will be approximated.}

\item{solution}{the result of function "Transition_Zone_Near_Boundary" or "Transition_Zone_Far_Boundary" or "Extreme_Zone"}
}
\value{
new krigGrid and new data
importFrom sp plot
}
\description{
new_krigGrid_for_visualisation
}
\details{
Elementary function that create a new krigGrid by replacing the real values by the approximation of the function
"Transition_Zone_Near_Boundary","Transition_Zone_Far_Boundary" or "Extreme_Zone" in order to have a look at the new iso contour
}
\examples{
\donttest{
 seed=2
 map=genMap(DataObj=NULL,seed=seed,krig=2,typeMod="Gau")
 ZK=initialZoning(qProb=c(0.55,0.85),map)
 Z=ZK$resZ$zonePolygone # list of zones
 lab = ZK$resZ$lab # label of zones
 plotM(map = map,Z = Z,lab = lab, byLab = FALSE)
 numZ = 6
 Estimation = Transition_Zone_Near_Boundary(map = map, Z = Z, numZ = numZ)
 result = new_krigGrid_for_visualisation(map = map, Z = Z, numZ = numZ, solution = Estimation)
 new_krigGrid = result$new_krigGrid
 new_data = result$new_data
 quant1 = quantile(map$krigData@data$var1.pred,probs = 0.55)
 quant2 = quantile(map$krigData@data$var1.pred,probs = 0.85)
 # plot initial isocontours
 plotM(map = map,Z = Z,lab = lab, byLab = TRUE)
 listContours = contourBetween(map = map, krigGrid = map$krigGrid, q1 = quant1, q2 = quant2)
 for (i in 1:length(listContours)){
   sp::plot(listContours[[i]]$contour,add=TRUE,col = "red")
 }
 # plot modified isocontours
 plotM(map = map,Z = Z,lab = lab, byLab = TRUE)
 listContours = contourBetween(map = map, krigGrid = new_krigGrid, q1 = quant1, q2 = quant2)
 for (i in 1:length(listContours)){
   sp::plot(listContours[[i]]$contour,add=TRUE,col = "red")
 }
}
}
