% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggparallel_specific_utils.R
\name{count_edge_crossings}
\alias{count_edge_crossings}
\title{Count Edge Crossings in Parallel Coordinates}
\usage{
count_edge_crossings(l, r)
}
\arguments{
\item{l}{A numeric vector representing values on the left axis. Must have the
same length as \code{r}.}

\item{r}{A numeric vector representing values on the right axis. Must have
the same length as \code{l}.}
}
\value{
An integer indicating the total number of edge crossings.
}
\description{
Calculates the total number of edge crossings between two numeric vectors in a
2-column parallel coordinates setup. Each axis represents one of the columns.
}
\details{
An edge crossing occurs when two edges intersect between the axes.
Formally, edges \eqn{(l[i], r[i])} and \eqn{(l[j], r[j])} cross if
\eqn{(l[i] - l[j]) * (r[i] - r[j]) < 0}.
}
\keyword{internal}
