% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geonorge_bathymetry.R
\name{geonorge_bathymetry}
\alias{geonorge_bathymetry}
\title{Open Geonorge bathymetry shapefiles}
\usage{
geonorge_bathymetry(filepath, layer = NULL, verbose = FALSE)
}
\arguments{
\item{filepath}{Character string defining the path to the \code{.gml} file. Must contain the file extension.}

\item{layer}{Character string defining the layer containing depth information. If \code{NULL} assumed to be "dybdeareal".}

\item{verbose}{Logical indicating whether information the reading process should be returned.}
}
\value{
An \link[sf:st_polygon]{sf} or \code{sp} object containing the depth polygons. Uses same projection than \code{bathy} (see \code{\link[sf:st_crs]{CRS}}).
}
\description{
Opens and formats Geonorge bathymetry shapefiles ready for plotting in ggOceanMaps
}
\details{
You can download the bathymetry polygon shapefiles from \href{https://kartkatalog.geonorge.no/metadata/kartverket/dybdedata/2751aacf-5472-4850-a208-3532a51c529a}{Geonorge}. Download the file in \code{GLM} format.
}
\seealso{
Other create shapefiles: 
\code{\link{clip_shapefile}()},
\code{\link{raster_bathymetry}()},
\code{\link{vector_bathymetry}()}
}
\author{
Mikko Vihtakari
}
\concept{create shapefiles}
