% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-attractsegment.R
\name{position_attractsegment}
\alias{position_attractsegment}
\title{Nudge points towards each other along a line}
\usage{
position_attractsegment(
  start_shave = 0,
  end_shave = 0,
  type_shave = c("proportion", "distance")
)
}
\arguments{
\item{start_shave, end_shave}{The amount of distance to "shave" off the line between (`x`,`y`) and (`xend`,`yend`),
at, respectively, the start and the end. Can be zero; cannot be negative. Units are determined by `type_shave`.}

\item{type_shave}{If "proportion" (the default) then this is a proportion of the total line length. If "distance"
then it is instead the raw distance along the line. The is only really recommended in combination with
[ggplot2::coord_fixed()]; results can be quite odd otherwise.}
}
\value{
A ggproto object
}
\description{
This position function is primarily intended for use with [geom_arrowsegment()], and solves the problem
that the user may, for reasons of clarity or aesthetics, not want their arrows to actually start or end at
the position that they are "pointing from" or "pointing to". It works by shifting the points towards each
other along the line joining them, by either a proportional amount or a fixed distance.
}
\examples{

 library(ggplot2)
 library(magrittr)
 library(tidyr)

 # Generate some dummy data

 ten.points <- data.frame(line.no = rep(1:5, each = 2), x = runif(10), y = runif(10),
                          position = rep(c("start", "end"), 5))
 five.segments <- ten.points \%>\% pivot_wider(names_from = position, values_from = c(x,y))

 # Ten percent off the start and end

 ggplot(five.segments) +
   geom_point(data = ten.points, aes(x = x, y = y)) +
   geom_arrowsegment(aes(x = x_start, xend = x_end, y = y_start, yend = y_end),
                     position = position_attractsegment(start_shave = 0.1, end_shave = 0.1))

 # Absolute distance of 0.02 at the end only

 ggplot(five.segments) +
   geom_point(data = ten.points, aes(x = x, y = y)) +
   geom_arrowsegment(aes(x = x_start, xend = x_end, y = y_start, yend = y_end),
                     position = position_attractsegment(end_shave = 0.02,
                                                        type_shave = "distance")) +
   coord_fixed()
}
\concept{position adjustments}
