% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_density.R
\name{gg_density}
\alias{gg_density}
\title{Density ggplot.}
\usage{
gg_density(
  data = NULL,
  x = NULL,
  y = NULL,
  col = NULL,
  facet = NULL,
  group = NULL,
  stat = "density",
  position = "identity",
  pal = NULL,
  pal_na = "#7F7F7F",
  alpha = 0.5,
  size = 0.5,
  ...,
  title = NULL,
  subtitle = NULL,
  coord = ggplot2::coord_cartesian(clip = "off"),
  x_breaks = NULL,
  x_breaks_n = NULL,
  x_breaks_width = NULL,
  x_expand = NULL,
  x_labels = NULL,
  x_limits = NULL,
  x_oob = scales::oob_censor,
  x_title = NULL,
  x_zero = NULL,
  x_zero_mid = FALSE,
  y_breaks = NULL,
  y_breaks_n = NULL,
  y_breaks_width = NULL,
  y_expand = NULL,
  y_labels = NULL,
  y_limits = NULL,
  y_oob = scales::oob_censor,
  y_title = NULL,
  y_zero = NULL,
  y_zero_mid = FALSE,
  col_breaks = NULL,
  col_breaks_n = NULL,
  col_breaks_width = NULL,
  col_intervals = NULL,
  col_labels = NULL,
  col_legend_place = NULL,
  col_legend_ncol = NULL,
  col_legend_nrow = NULL,
  col_limits = NULL,
  col_title = NULL,
  facet_intervals = NULL,
  facet_labels = NULL,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_scales = "fixed",
  caption = NULL,
  theme = NULL
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{x}{Unquoted x aesthetic variable.}

\item{y}{Unquoted y aesthetic variable.}

\item{col}{Unquoted col and fill aesthetic variable.}

\item{facet}{Unquoted facet aesthetic variable.}

\item{group}{Unquoted group aesthetic variable.}

\item{stat}{Statistical transformation. A character string (e.g. "identity").}

\item{position}{Position adjustment. Either a character string (e.g."identity"), or a function (e.g. ggplot2::position_identity()).}

\item{pal}{Colours to use. A character vector of hex codes (or names).}

\item{pal_na}{Colour to use for NA values. A character vector of a hex code (or name).}

\item{alpha}{Opacity. A number between 0 and 1.}

\item{size}{Size. A number 0 upwards.}

\item{...}{Other arguments passed to the relevant ggplot2::geom_* function.}

\item{title}{Title string.}

\item{subtitle}{Subtitle string.}

\item{coord}{Coordinate system.}

\item{x_breaks}{For a numeric or date variable, a vector of breaks for the axis.}

\item{x_breaks_n}{For a numeric or date variable, an integer guiding the number of breaks, as calculated by the pretty function.}

\item{x_breaks_width}{For a numeric or date variable, the width of breaks, as calculated by the scales::fullseq function.}

\item{x_expand}{Add padding to the limits with the ggplot2::expansion function, or a vector of length 2.}

\item{x_labels}{A function to format the scale labels, including in rlang lambda format. Use ~.x to remove default transformation. If numeric, accepts a vector. If categorical, accepts a named vector (e.g. c(value = "label", ...)).}

\item{x_limits}{For a numeric or date variable, a vector of length 2 to determine the limits of the axis. For a numeric variable, use c(NA, NA) to use the min and max as limits. For a date variable, load lubridate package and use c(NA_Date_, NA_Date_) to use the min and max as limits.}

\item{x_oob}{A scales::oob_* function for how to deal with out-of-bounds values.}

\item{x_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{x_zero}{For a numeric variable, TRUE or FALSE of whether the axis should include zero. Defaults to FALSE.}

\item{x_zero_mid}{For a numeric variable, TRUE or FALSE of whether to put zero in the middle of the axis. Defaults to FALSE.}

\item{y_breaks}{For a numeric or date variable, a vector of breaks for the axis.}

\item{y_breaks_n}{For a numeric or date variable, an integer guiding the number of breaks, as calculated by the pretty function.}

\item{y_breaks_width}{For a numeric or date variable, the width of breaks, as calculated by the scales::fullseq function.}

\item{y_expand}{Add padding to the limits with the ggplot2::expansion function, or a vector of length 2.}

\item{y_labels}{A functiyon to format the scale labels, including in rlang lambda format. Use ~.x to remove default transformation. If numeric, accepts a vector. If categorical, accepts a named vector (e.g. c(value = "label", ...)).}

\item{y_limits}{For a numeric or date variable, a vector of length 2 to determine the limits of the axis. For a numeric variable, use c(NA, NA) to use the min and max as limits. For a date variable, load lubridate package and use c(NA_Date_, NA_Date_) to use the min and max as limits.}

\item{y_oob}{A scales::oob_* function for how to deal with out-of-bounds values.}

\item{y_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{y_zero}{For a numeric variable, TRUE or FALSE of whether the axis should include zero. Defaults to FALSE.}

\item{y_zero_mid}{For a numeric variable, TRUE or FALSE of whether to put zero in the middle of the axis. Defaults to FALSE.}

\item{col_breaks}{A vector of breaks. For a categorical col variable, this links pal values with col variable values dropping those not used. For a numeric variable where col_intervals is NULL, this only affects the labels on the legend.}

\item{col_breaks_n}{For a numeric variable where col_intervals is NULL, an integer guiding the number of breaks, as calculated by the pretty function.}

\item{col_breaks_width}{For a numeric variable, the width of breaks, as calculated by the scales::fullseq function.}

\item{col_intervals}{A function to cut or chop the numeric variable into intervals, including in rlang lambda format (e.g. ~ santoku::chop_mean_sd(.x, drop = FALSE)).}

\item{col_labels}{A function to format the scale labels, including in rlang lambda format. Use ~.x to remove default transformation. If categorical, accepts a named vector (e.g. c(value = "label", ...)). Note this does not affect where col_intervals is not NULL.}

\item{col_legend_place}{The place for the legend. "r" for right, "b" for bottom, "t" for top, or "l" for left.}

\item{col_legend_ncol}{The number of columns for the legend elements.}

\item{col_legend_nrow}{The number of rows for the legend elements.}

\item{col_limits}{A vector of limits. For a categorical col variable, this links pal values with col variable values keeping those not used. For a numeric variable where col_intervals is NULL, this will make all values outside the limits coloured NA.}

\item{col_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{facet_intervals}{A function to cut or chop the numeric variable into intervals, including in rlang lambda format (e.g. ~ santoku::chop_mean_sd(.x, drop = FALSE)).}

\item{facet_labels}{A function to format the scale labels, including in rlang lambda format. Use ~.x to remove default transformation. If categorical, accepts a named vector (e.g. c(value = "label", ...)).}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string.}

\item{theme}{A ggplot2 theme.}
}
\value{
A ggplot object.
}
\description{
Create a density plot with a wrapper around the ggplot2::geom_density function.
}
\examples{
library(ggplot2)
gg_density(diamonds, x = carat)
gg_density(diamonds, y = carat)
gg_density(diamonds, x = carat, adjust = 1/5)
gg_density(diamonds, x = carat, adjust = 5)
gg_density(diamonds, x = depth, col = cut, x_limits = c(55, 70))
gg_density(diamonds, x = carat, col = cut, position = "stack", alpha = 0.9)
gg_density(diamonds, x = carat, col = cut, position = "fill", alpha = 0.9)

}
