% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbrain_layer_outline.R
\name{ggbrain_layer_outline}
\alias{ggbrain_layer_outline}
\title{R6 class for a single layer of a ggbrain panel using outline geom}
\value{
a \code{ggbrain_layer_outline} R6 class with fields related to a brain visual layer (relates to \code{geom_outline})
}
\description{
R6 class for a single layer of a ggbrain panel using outline geom

R6 class for a single layer of a ggbrain panel using outline geom
}
\details{
Note that this class is exported only for power users and rarely needs to be called directly
in typical use of the package. Instead, look at \code{geom_outline()}.
}
\section{Super class}{
\code{\link[ggbrain:ggbrain_layer]{ggbrain::ggbrain_layer}} -> \code{ggbrain_layer_outline}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{mapping}}{the ggplot2 aesthetic mapping between the data columns and the display}

\item{\code{outline}}{controls color of outline draw around non-NA (valid) voxels}

\item{\code{outline_scale}}{a scale_fill_* object containing the ggplot2 outline color scale for this layer}

\item{\code{size}}{controls size of outline drawn around non-NA (valid) voxels}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ggbrain_layer_outline-new}{\code{ggbrain_layer_outline$new()}}
\item \href{#method-ggbrain_layer_outline-clone}{\code{ggbrain_layer_outline$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="add_to_gg"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-add_to_gg'><code>ggbrain::ggbrain_layer$add_to_gg()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="get_data"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-get_data'><code>ggbrain::ggbrain_layer$get_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="is_empty"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-is_empty'><code>ggbrain::ggbrain_layer$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="plot"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-plot'><code>ggbrain::ggbrain_layer$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_breaks"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_breaks'><code>ggbrain::ggbrain_layer$set_breaks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_limits"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_limits'><code>ggbrain::ggbrain_layer$set_limits()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_neg_breaks"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_neg_breaks'><code>ggbrain::ggbrain_layer$set_neg_breaks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_neg_limits"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_neg_limits'><code>ggbrain::ggbrain_layer$set_neg_limits()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_pos_breaks"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_pos_breaks'><code>ggbrain::ggbrain_layer$set_pos_breaks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_pos_limits"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_pos_limits'><code>ggbrain::ggbrain_layer$set_pos_limits()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer_outline-new"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer_outline-new}{}}}
\subsection{Method \code{new()}}{
create a new ggbrain_layer object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer_outline$new(
  name = NULL,
  definition = NULL,
  limits = NULL,
  breaks = integer_breaks(),
  show_legend = TRUE,
  interpolate = NULL,
  unify_scales = TRUE,
  alpha = NULL,
  mapping = ggplot2::aes(outline = NULL, fill = NULL),
  outline = NULL,
  outline_scale = NULL,
  size = NULL,
  blur_edge = NULL,
  fill_holes = NULL,
  remove_specks = NULL,
  trim_threads = NULL,
  data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the name of this layer, used for referencing in layer and panel modifications}

\item{\code{definition}}{an optional character string defining the image or contrast that should be used
to lookup data from a ggbrain_slices object. This is mostly used internally by the ggbrain + syntax
to allow layers to be defined without data in advance of the plot.}

\item{\code{limits}}{if provided, sets the upper and lower bounds on the scale}

\item{\code{breaks}}{if provided, a function to draw the breaks on the color scale}

\item{\code{show_legend}}{if TRUE, show the scale on the plot legend}

\item{\code{interpolate}}{passes to geom_raster and controls whether the fill is interpolated over continuous space}

\item{\code{unify_scales}}{if TRUE, when this layer is reused across panels, unify the scales to match}

\item{\code{alpha}}{a number between 0 and 1 that sets the alpha transparency of this layer. Default: 1}

\item{\code{mapping}}{the aesthetic mapping of the layer data to the display. Should be an aes() object and supports
\code{outline} (color of outline around clusters). Default is \code{aes(outline=value)}, which maps the numeric value of the layer data
to the outline color of the squares at around spatial regions. For labeled data, you might use \code{aes(fill=<label_col_name>)}.}

\item{\code{outline}}{A character string indicating the color used to outline all non-NA pixels in this layer. This is used in
distinction to \code{mapping=aes(outline=<variable>)}.}

\item{\code{outline_scale}}{a ggplot scale object used for mapping the value column as the outline color for the layer.}

\item{\code{size}}{controls the thickness of outlines}

\item{\code{blur_edge}}{the standard deviation (sigma) of a Gaussian kernel applied to the edge of this layer to
smooth it. This makes the layer less jagged in appearance and is akin to antialiasing.}

\item{\code{fill_holes}}{the size of holes (in pixels) inside clusters to be filled by nearest neighbor imputation prior to display}

\item{\code{remove_specks}}{the size of specks (in pixels) to be removed from each slice prior to display}

\item{\code{trim_threads}}{the minimum number of neighboring pixels (including diagonals) that must be present to keep a pixel}

\item{\code{data}}{the data.frame containing image data for this layer. Must contain "dim1", "dim2",
and "value" as columns}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
To set mapping, you must provide a ggplot2 aes() object. A geom_outline() layer requires
an \code{outline} aesthetic mapping, which controls the color of outlines drawn around regions.


note that the ggbrain_layer_outline class maps onto *_fill fields
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer_outline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer_outline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer_outline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
