% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdag.R
\name{ggdag}
\alias{ggdag}
\title{Quickly plot a DAG in ggplot2}
\usage{
ggdag(
  .tdy_dag,
  ...,
  edge_type = "link_arc",
  node_size = 16,
  text_size = 3.88,
  label_size = text_size,
  text_col = "white",
  label_col = "black",
  node = TRUE,
  stylized = FALSE,
  text = TRUE,
  use_labels = NULL
)
}
\arguments{
\item{.tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{...}{additional arguments passed to \code{tidy_dagitty()}}

\item{edge_type}{a character vector, the edge geom to use. One of:
"link_arc", which accounts for directed and bidirected edges, "link",
"arc", or "diagonal"}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{color of label text}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_label_repel()}.
Default is \code{NULL}.}
}
\value{
a \code{ggplot}
}
\description{
\code{ggdag()} is a wrapper to quickly plot DAGs.
}
\examples{

dag <- dagify(
  y ~ x + z2 + w2 + w1,
  x ~ z1 + w1,
  z1 ~ w1 + v,
  z2 ~ w2 + v,
  w1 ~ ~w2
)

ggdag(dag)
ggdag(dag) + theme_dag_blank()

ggdag(dagitty::randomDAG(5, .5))

}
\seealso{
\code{\link[=ggdag_classic]{ggdag_classic()}}
}
