% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_stats.R
\name{autoplot.pca_common}
\alias{autoplot.pca_common}
\alias{autoplot.prcomp}
\alias{autoplot.princomp}
\alias{autoplot.factanal}
\title{Autoplot PCA-likes}
\usage{
\method{autoplot}{pca_common}(object, data = NULL, scale = 1, x = 1,
  y = 2, ...)
}
\arguments{
\item{object}{PCA-like instance}

\item{data}{Joined to fitting result if provided.}

\item{scale}{scaling parameter, disabled by 0}

\item{x}{principal component number used in x axis}

\item{y}{principal component number used in y axis}

\item{...}{other arguments passed to \code{ggbiplot}}
}
\description{
Autoplot PCA-likes
}
\examples{
autoplot(stats::prcomp(iris[-5]))
autoplot(stats::prcomp(iris[-5]), data = iris)
autoplot(stats::prcomp(iris[-5]), data = iris, colour = 'Species')
autoplot(stats::prcomp(iris[-5]), label = TRUE, loadings = TRUE, loadings.label = TRUE)
autoplot(stats::prcomp(iris[-5]), frame = TRUE)
autoplot(stats::prcomp(iris[-5]), data = iris, frame = TRUE,
         frame.colour = 'Species')
autoplot(stats::prcomp(iris[-5]), data = iris, frame = TRUE,
         frame.type = 't', frame.colour = 'Species')

autoplot(stats::princomp(iris[-5]))
autoplot(stats::princomp(iris[-5]), data = iris)
autoplot(stats::princomp(iris[-5]), data = iris, colour = 'Species')
autoplot(stats::princomp(iris[-5]), label = TRUE, loadings = TRUE, loadings.label = TRUE)

d.factanal <- stats::factanal(state.x77, factors = 3, scores = 'regression')
autoplot(d.factanal)
autoplot(d.factanal, data = state.x77, colour = 'Income')
autoplot(d.factanal, label = TRUE, loadings = TRUE, loadings.label = TRUE)
}
