% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_vars.R
\name{fortify.varprd}
\alias{fortify.varprd}
\title{Convert \code{vars::varprd} to \code{data.frame}}
\usage{
\method{fortify}{varprd}(model, data = NULL, is.date = NULL,
  ts.connect = FALSE, melt = FALSE, ...)
}
\arguments{
\item{model}{\code{vars::varprd} instance}

\item{data}{original dataset, if needed}

\item{is.date}{Logical frag indicates whether the \code{stats::ts} is date or not.
If not provided, regard the input as date when the frequency is 4 or 12.}

\item{ts.connect}{Logical frag indicates whether connects original time-series and predicted values}

\item{melt}{Logical flag indicating whether to melt each timeseries as variable}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert \code{vars::varprd} to \code{data.frame}
}
\examples{
data(Canada, package = 'vars')
d.var <- vars::VAR(Canada, p = 3, type = 'const')
fortify(stats::predict(d.var, n.ahead = 50))
}
