% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_point_interactive.R
\name{geom_point_interactive}
\alias{geom_point_interactive}
\title{interactive points}
\usage{
geom_point_interactive(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, see \code{\link[ggplot2]{geom_point}}.}

\item{data}{A data frame, see \code{\link[ggplot2]{geom_point}}.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string, see \code{\link[ggplot2]{geom_point}}.}

\item{position}{Postion adjustment, see \code{\link[ggplot2]{geom_point}}.}

\item{na.rm}{See \code{\link[ggplot2]{geom_point}}.}

\item{show.legend}{See \code{\link[ggplot2]{geom_point}}.}

\item{inherit.aes}{See \code{\link[ggplot2]{geom_point}}.}

\item{...}{other arguments passed on to layer. See \code{\link[ggplot2]{geom_point}}.}
}
\description{
The geometry is based on \code{\link[ggplot2]{geom_point}}.
See the documentation for those functions for more details.
}
\note{
The following shapes id 3, 4 and 7 to 14 are composite symbols and should not be used.
}
\examples{
# add interactive points to a ggplot -------
# create dataset
dataset = iris
dataset$tooltip = dataset$Species
dataset$clickjs = paste0("alert(\\"",dataset$Species, "\\")" )

# plots
gg_point = ggplot(dataset, aes(x = Sepal.Length, y = Petal.Width,
		color = Species, tooltip = tooltip, onclick = clickjs) ) +
	geom_point_interactive()

ggiraph(code = {print(gg_point)})
}
\seealso{
\code{\link{ggiraph}}
}

