## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

library(ggparliament)
library(dplyr)
library(ggplot2)
require(tidyr)
require(magrittr)

source("../R/parliament_data.R")
source("../R/geom_parliament_seats.R")
source("../R/geom_highlight_government.R")
source("../R/helper_funcs.R")
source("../R/draw_majoritythreshold.R")
source("../R/draw_partylabels.R")
source("../R/draw_majoritythreshold.R")
source("../R/draw_totalseats.R")
source("../R/theme_ggparliament.R")
load("../R/sysdata.rda")


## ---- fig.width=6, fig.height=4------------------------------------------
data <- election_data %>% 
    filter(year == "2016" & 
             country == "USA" & 
             house == "Representatives")

usa_data <- parliament_data(election_data = data, 
                            type = "semicircle", 
                            party_seats = data$seats, 
                            parl_rows = 8)

ggplot(usa_data, aes(x, y, color=party_long)) + 
    geom_parliament_seats() + 
    labs(colour = NULL) +
    draw_partylabels(type = "semicircle", party_names = party_short, 
    party_seats = seats, party_colours = colour) +
    scale_colour_manual(values = usa_data$colour, 
                        limits = usa_data$party_long) +
    theme_ggparliament(legend = FALSE) 

## ----fig.width=4, fig.height=4-------------------------------------------
australia <- election_data %>%
  filter(country == "Australia" &
    house == "Representatives" &
    year == 2016) 

australia_horseshoe <- parliament_data(election_data = australia,
  party_seats = australia$seats,
  parl_rows = 4,
  type = "horseshoe")

au <- ggplot(australia_horseshoe, aes(x, y, colour = party_short)) +
  geom_parliament_seats() + 
  theme_ggparliament(legend = FALSE) +
  labs(colour = NULL, 
       title = "Australian Parliament") +
  draw_partylabels(type = "horseshoe", party_names = party_short, 
    party_seats = seats, party_colours = colour) + 
  scale_colour_manual(values = australia$colour, 
                      limits = australia$party_short) 

au

## ---- fig.width=6, fig.height=4------------------------------------------
data <- election_data %>% 
    filter(year == "2016" & 
             country == "USA" & 
             house == "Representatives")

usa_data <- parliament_data(election_data = data, 
                            type = "semicircle", 
                            party_seats = data$seats, 
                            parl_rows = 8)

ggplot(usa_data, aes(x, y, color=party_long)) + 
    geom_parliament_seats() + 
    labs(colour = NULL) +
    draw_totalseats(n = 435,
                    type = "semicircle") +
    scale_colour_manual(values = usa_data$colour, 
                        limits = usa_data$party_long) +
    theme_ggparliament(legend = FALSE) 

