% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-locuszoom.R
\name{pal_locuszoom}
\alias{pal_locuszoom}
\title{LocusZoom color palette}
\usage{
pal_locuszoom(palette = c("default"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"default"}
(7-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}
}
\description{
Color palettes based on the colors used by LocusZoom.
}
\examples{
library("scales")
show_col(pal_locuszoom("default")(7))
show_col(pal_locuszoom("default", alpha = 0.6)(7))
}
\references{
Pruim, Randall J., et al. (2010). LocusZoom: regional visualization of
genome-wide association scan results. \emph{Bioinformatics},
26(18), 2336--2337.
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
