% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-filter-spct.R
\name{plot.object_spct}
\alias{plot.object_spct}
\alias{plot.object_mspct}
\title{Plot method for object spectra.}
\usage{
\method{plot}{object_spct}(x, ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(), UVB(),
  UVA(), PAR())), range = NULL, plot.qty = "all", pc.out = FALSE,
  label.qty = NULL, span = 61, annotations = NULL, time.format = "",
  tz = "UTC", stacked = TRUE, text.size = 2.5, na.rm = TRUE)

\method{plot}{object_mspct}(x, ..., range = NULL)
}
\arguments{
\item{x}{an object_spct object}

\item{...}{other arguments passed along, such as \code{label.qty}}

\item{w.band}{a single waveband object or a list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{plot.qty}{character string, one of "all", "transmittance",
"absorbance", "absorptance", or "reflectance".}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector}

\item{time.format}{character Format as accepted by \code{\link[base]{strptime}}.}

\item{tz}{character Time zone to use for title and/or subtitle.}

\item{stacked}{logical}

\item{text.size}{numeric size of text in the plot decorations.}

\item{na.rm}{logical.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of an
object_spct object.
}
\note{
The ggplot object returned can be further manipulated and added to.
  Except when no annotations are added, limits are set for the x-axis and
  y-axis scales. The y scale limits are expanded to include all data, or at
  least to the range of expected values. Scales are further expanded so
  as to make space for the annotations.
}
\examples{

library(photobiology)
plot(Ler_leaf.spct)

}
\seealso{
Other plot functions: \code{\link{plot.calibration_spct}},
  \code{\link{plot.cps_spct}},
  \code{\link{plot.filter_spct}},
  \code{\link{plot.raw_spct}},
  \code{\link{plot.reflector_spct}},
  \code{\link{plot.response_spct}},
  \code{\link{plot.source_spct}},
  \code{\link{plot.waveband}}
}
\keyword{hplot}
