% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-raw-spct.R
\name{scale_y_counts_continuous}
\alias{scale_y_counts_continuous}
\alias{scale_y_counts_tg_continuous}
\title{Raw-counts y-scale}
\usage{
scale_y_counts_continuous(unit.exponent = 3,
  name = counts_label(unit.exponent = unit.exponent),
  labels = SI_pl_format(exponent = unit.exponent), ...)

scale_y_counts_tg_continuous(unit.exponent = 3,
  name = counts_label(unit.exponent = 0), labels = SI_tg_format(exponent =
  unit.exponent), ...)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for raw detector counts.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{
library(ggplot2)
library(photobiology)

ggplot(white_led.raw_spct) +
  geom_line() +
  scale_y_counts_continuous() +
  scale_x_wl_continuous()

ggplot(white_led.raw_spct) +
  geom_line() +
  scale_y_counts_continuous(0) +
  scale_x_wl_continuous()

ggplot(white_led.raw_spct) +
  geom_line() +
  scale_y_counts_tg_continuous() +
  scale_x_wl_continuous()

}
