% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-source-spct.R
\name{scale_y_s.e.irrad_continuous}
\alias{scale_y_s.e.irrad_continuous}
\alias{scale_y_s.q.irrad_continuous}
\alias{scale_y_s.q.irrad_log10}
\alias{scale_y_s.e.irrad_log10}
\title{Spectral irradiance y-scale}
\usage{
scale_y_s.e.irrad_continuous(unit.exponent = 0,
  name = s.e.irrad_label(unit.exponent), labels = SI_pl_format(exponent
  = unit.exponent), ...)

scale_y_s.q.irrad_continuous(unit.exponent = -6,
  name = s.q.irrad_label(unit.exponent = unit.exponent),
  labels = SI_pl_format(exponent = unit.exponent), ...)

scale_y_s.q.irrad_log10(unit.exponent = -6,
  name = s.q.irrad_label(unit.exponent = unit.exponent),
  labels = SI_pl_format(exponent = unit.exponent), ...)

scale_y_s.e.irrad_log10(unit.exponent = 0,
  name = s.e.irrad_label(unit.exponent), labels = SI_pl_format(exponent
  = unit.exponent), ...)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for raw detector counts.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{
library(ggplot2)
library(photobiology)

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous() +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_continuous(-1) +
  scale_x_wl_continuous()

ggplot(sun.spct, unit.out = "photon") +
  geom_line() +
  scale_y_s.q.irrad_continuous() +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_y_s.e.irrad_log10() +
  scale_x_wl_continuous()

ggplot(sun.spct, unit.out = "photon") +
  geom_line() +
  scale_y_s.q.irrad_log10() +
  scale_x_wl_continuous()

}
