% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-response-spct.r
\name{e_rsp_plot}
\alias{e_rsp_plot}
\title{Create a complete ggplot for response spectra.}
\usage{
e_rsp_plot(
  spct,
  w.band,
  range,
  pc.out,
  label.qty,
  span,
  wls.target,
  annotations,
  norm,
  text.size,
  idfactor,
  ylim,
  na.rm,
  ...
)
}
\arguments{
\item{spct}{a response_spct object.}

\item{w.band}{list of waveband objects.}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm).}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one.}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{wls.target}{numeric vector indicating the spectral quantity values for
which wavelengths are to be searched and interpolated if need. The
\code{character} strings "half.maximum" and "half.range" are also accepted
as arguments. A list with \code{numeric} and/or \code{character} values is
also accepted.}

\item{annotations}{a character vector.}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried.}

\item{ylim}{numeric y axis limits,}

\item{na.rm}{logical.}

\item{...}{currently ignored.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
response_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\keyword{internal}
