% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtitle_maker_templates.R
\name{subtitle_template}
\alias{subtitle_template}
\title{Template for subtitles with statistical details for tests with a
single parameter (e.g., t, chi-squared, etc.)}
\usage{
subtitle_template(no.parameters, stat.title = NULL, statistic.text,
  statistic, parameter = NULL, parameter2 = NULL, p.value,
  effsize.text, effsize.estimate, effsize.LL, effsize.UL, n,
  conf.level = 0.95, k = 2L, k.parameter = 0L, k.parameter2 = 0L)
}
\arguments{
\item{no.parameters}{An integer that specifies that the number of parameters
for the statistical test. Can be \code{0} for non-parametric tests, \code{1} for
tests based on \emph{t}-statistic or chi-squared statistic, \code{2} for tests based
on \emph{F}-statistic.}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{statistic.text}{A character that specifies the relevant test statistic.
For example, for tests with \emph{t}-statistic, \code{statistic.text = "t"}. If you
want to use plotmath, you will have to quote the argument (e.g.,
\code{quote(italic("t"))}).}

\item{statistic}{The numeric value of a statistic.}

\item{parameter}{The numeric value of a parameter being modeled (often
degrees of freedom for the test). Default is \code{NULL} to accommodate
non-parametric tests.}

\item{parameter2}{Relevant only if the statistic in question has two degrees
of freedom (default: \code{NULL}).}

\item{p.value}{The two-sided p-value associated with the observed statistic.}

\item{effsize.text}{A character that specifies the relevant effect size.
For example, for Cohen's \emph{d} statistic, \code{effsize.text = "d"}. If you
want to use plotmath, you will have to quote the argument (e.g.,
\code{quote(italic("d"))}).}

\item{effsize.estimate, effsize.LL, effsize.UL}{The estimated value of the
effect size, its lower bound, and its upper.}

\item{n}{An integer specifying the sample size used for the test.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{k.parameter, k.parameter2}{Number of decimal places to display for the
parameters (default: \code{0}).}
}
\description{
Template for subtitles with statistical details for tests with a
single parameter (e.g., t, chi-squared, etc.)
}
\examples{
set.seed(123)

# subtitle for *t*-statistic with Cohen's *d* as effect size
ggstatsplot::subtitle_template(
  no.parameters = 1L,
  statistic.text = quote(italic("t")),
  statistic = 5.494,
  parameter = 29.234,
  p.value = 0.00001,
  effsize.text = quote(italic("d")),
  effsize.estimate = -1.980,
  effsize.LL = -2.873,
  effsize.UL = -1.088,
  n = 32L,
  conf.level = 0.95,
  k = 3L,
  k.parameter = 3L
)
}
\author{
Indrajeet Patil
}
