% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetweenstats_graphics.R
\name{aesthetic_addon}
\alias{aesthetic_addon}
\title{Making aesthetic modifications to the plot}
\usage{
aesthetic_addon(
  plot,
  x,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ggtheme = ggplot2::theme_bw(),
  ggstatsplot.layer = TRUE,
  package = "RColorBrewer",
  palette = "Dark2",
  direction = 1,
  ggplot.component = NULL,
  ...
)
}
\arguments{
\item{plot}{Plot to be aesthetically modified.}

\item{x}{A numeric vector for \code{x} axis.}

\item{xlab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{ylab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption.}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}

\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{If a character string (e.g., \code{"Set1"}), will use that named
palette. If a number, will index into the list of palettes of appropriate
type. Default palette is \code{"Dark2"}.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function. If the given function has an argument \code{axes.range.restrict}
and if it has been set to \code{TRUE}, the added \code{ggplot} component \emph{might} not
work as expected.}

\item{...}{Additional arguments.}
}
\description{
Making aesthetic modifications to the plot
}
\keyword{internal}
