% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateVAR.R
\name{simulateVAR}
\alias{simulateVAR}
\title{Simulate data from Vector AutoRegression (VAR) models.}
\usage{
simulateVAR(A   = NULL, 
            Phi       = NULL, 
            Psi       = NULL, 
            subAssign = NULL, 
            N         = NULL, 
            ASign     = "random",  
            PhiSign   = "random",  
            Obs       = NULL,
            indA      = 0.01, 
            indPhi    = 0.01,
            indPsi    = 0.00)
}
\arguments{
\item{A}{A matrix (for no subgroups) or list of A matrices, with slice # = # of subgroups.}

\item{Phi}{Phi matrix (for no subgroups) or list of Phi matrices, with slice # = # of subgroups.}

\item{Psi}{matrix (for no subgroups) or list of Psi matrices, with slice # = # of subgroups.}

\item{subAssign}{Optional vector of length N that indicates which subgroup each individual is in.}

\item{N}{Number of indvidiuals.}

\item{ASign}{Defaults to "random" for ind level paths, with 50 percent chance of positive and 50 percent negative, other option is either "neg" or "pos" which provides all negative or all positive relations, respectively.}

\item{PhiSign}{Defaults to "random" for ind level paths, with 50 percent chance of positive and 50 percent negative, other option is either "neg" or "pos" which provides all negative or all positive relations, respectively.}

\item{Obs}{Number of observations (T) per individual. Burn in of 400 is used to generate then discarded.}

\item{indA}{Sparsity of individual-level A paths. 0 indicates no individual-level. Use decimals. Default is 
0.01, meaning that each path that is not in the group-level A matrix has a 0.01 chance of being added.}

\item{indPhi}{Sparsity of individual-level Phi paths. 0 indicates no individual-level. Use decimals. Default is 
0.01, meaning that each path that is not in the group-level Phi matrix has a 0.01 chance of being added.}

\item{indPsi}{Sparsity of individual-level Psi paths. 0 indicates no individual-level. Use decimals. Default is 
0, meaning that each path that is not in the group-level Psi matrix has a 0 chance of being added at the ind. level.
Individual- level paths added at this rate per individual.}
}
\description{
This function simulates data. It allows for structural VAR and VAR data generating models.
}
\author{
KM Gates, Ai Ye, Ethan McCormick, & Zachary Fisher
}
