% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git_history.R
\name{git_diff}
\alias{git_diff}
\title{Git Diff}
\usage{
git_diff(path = ".", ...)
}
\arguments{
\item{path}{Path or directory to compare - must be relative to the
root directory of the repository, regardless of whether \code{getwd()}
is a subdirectory.}

\item{...}{Two arguments to be passed for which versions to select: can be
a commit object from git_history() or get_git(), or a single filter
argument which is passed to get_git().}
}
\value{
A diffr htmlwidget object which is automatically opened in RStudio Viewer tab
}
\description{
Display the difference between two commits of a file or a directory structure.
Paths must be relative to the top-level git directory so it is recommended that
\code{getwd()} is the same so that tab auto-complete gives the right path. The default
filter is \code{n=1} and \code{NULL} meaning compare working tree (or a file contents)
of latest commit with current working directory.
}
\details{
Two commits can be specified using \code{git_get()} or \code{git_history()[[i]]}, or a
single named filter argument for each commit for simple requests. Use \code{NULL}
to compare with the current working file (not even committed yet).

Hidden files (for example '.Rbuildignore') are omitted when listing current
directory contents (a commit identifier of NULL), neither is .gitignore
respected, so all ignored files will be flagged up.

Usually the more recent commit should be second so that additions are shown
in green.

Previous versions of files can be opened for editing by finding them at the
\code{tempdir()} path.

See ?git_history for the filter arguments that can be used
}
\examples{
\dontrun{
# Compare the last committed change with current working version
git_diff() # this is exactly equivalent to next line
git_diff('.', n=1, NULL)
git_diff('README.md')
git_diff('README.md', n=2)
git_diff('README.md', n=2, n=1)

# Compare the directory structure now with a previous date
git_diff('.', before='2021-10-25')

# Latest between branches
git_diff('myfile', branch='master', branch='test')

# Compare file contents of a commit hash with most recent by author
git_diff('R/git_helper.R', hash='abc123', author='somebody')

# Can also get a git_commit object directly to pass over if multiple filtering
git_diff('R/', git_get(author='somebody', before='2021-10-25'), NULL)

# Or even taking a commit number from the branch history (but will be verbose)
git_diff('README.md', git_history()[[1]], n=1 )
}

}
\seealso{
git_history
}
