% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{gl_ci_job}
\alias{gl_ci_job}
\alias{gl_default_ci_pipeline}
\alias{use_gitlab_ci}
\title{Define Gitlab CI jobs}
\usage{
gl_ci_job(job_name, stage = job_name, allowed_dependencies = c(), ...)

gl_default_ci_pipeline()

use_gitlab_ci(pipeline = gl_default_ci_pipeline(),
  image = "rocker/r-devel:latest", path = ".gitlab-ci.yml",
  overwrite = TRUE, add_to_Rbuildignore = TRUE)
}
\arguments{
\item{job_name}{Name of job template to get CI definition elements}

\item{stage}{Name of stage job belongs to}

\item{allowed_dependencies}{List of job names that are allowed to be listed as dependencies of jobs. Usually this is all existing other jobs.}

\item{...}{passed on to ci_r_script: booleans vanilla or slave translate to R executable options with the same name}

\item{pipeline}{a CI pipeline defined as a list of lists}

\item{image}{Docker image to use in gitlab ci. If NULL, not specified!}

\item{path}{destination path for writing gitlab CI yml file}

\item{overwrite}{whether to overwrite existing gitlab CI yml file}

\item{add_to_Rbuildignore}{add CI yml file (from \code{path}) to .Rbuildignore?}
}
\description{
Define Gitlab CI jobs
}
