% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcn.R
\name{evaluate_plot}
\alias{evaluate_plot}
\title{Prediction visualization}
\usage{
evaluate_plot(y_pre, y_test, fam = "Gaussian", mod, y_train, cutp)
}
\arguments{
\item{y_pre}{predicted value}

\item{y_test}{actual value}

\item{fam}{type of predicted outcome, can be "Gaussian" (default), "Logisitc", and "Cox"}

\item{mod}{fitted glmagarph model, must be available for Cox if cutpoint not provided}

\item{y_train}{the training outcome to obtain}

\item{cutp}{cutpoint for Cox model}
}
\value{
plots
}
\description{
Sample plots for prediction evaluation (scatter plot for Gaussian, ROC curve for logistic, and Kaplan Meier curve for Cox)
}
\examples{
x <- rnorm(100)
y <- x + rnorm(100)
evaluate_plot(x, y)
}
