% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{format_data}
\alias{format_data}
\title{Format data for fitting a glmmfields model}
\usage{
format_data(data, y, X, time, lon = "lon", lat = "lat", station = NULL,
  nknots = 25L, covariance = c("squared-exponential", "exponential",
  "matern"), fixed_intercept = FALSE, cluster = c("pam", "kmeans"))
}
\arguments{
\item{data}{A data frame to be formatted}

\item{y}{A numeric vector of the response}

\item{X}{A matrix of the predictors}

\item{time}{A character object giving the name of the time column}

\item{lon}{A character object giving the name of the longitude column}

\item{lat}{A character object giving the name of the latitude column}

\item{station}{A numeric vector giving the integer ID of the station}

\item{nknots}{The number of knots}

\item{covariance}{The type of covariance function}

\item{fixed_intercept}{Should the intercept be fixed?}

\item{cluster}{The type of clustering algorithm used to determine the not locations.
\code{"pam"} = \code{\link[cluster]{pam}}. \code{kmeans} is faster for large datasets.}
}
\description{
Format data for fitting a glmmfields model
}
