% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nested.glmnetr_230508.R
\name{summary.nested.glmnetr}
\alias{summary.nested.glmnetr}
\title{Summarize a nested.glmnetr() output object}
\usage{
\method{summary}{nested.glmnetr}(object, cvfit = FALSE, printg1 = FALSE, short = 0, ...)
}
\arguments{
\item{object}{a nested.glmnetr() output object.}

\item{cvfit}{default of FALSE to summarize fit of a cross validation informed 
relaxed lasso model fit, inferred by nested cross validation.  Option of TRUE 
will describe the cross validation informed relaxed lasso model itself.}

\item{printg1}{TRUE to also print out the fully penalized lasso beta, else to suppress.
Only applies to cvfit=TRUE.}

\item{short}{optionally print just the CV agreement summaries (short=1)}

\item{...}{Additional arguments passed to the summary function.}
}
\value{
- a nested cross validation fit summary, or a cross validation model summary.
}
\description{
Summarize the model fit from a nested.glmnetr() output object, i.e. the fit of 
a cross-validation informed relaxed lasso model fit, inferred by nested cross 
validation.  Else summarize the cross-validated model fit.
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
fit3 = nested.glmnetr(xs, NULL, y_, event, family="cox", folds_n=3)  
summary(fit3)
}

}
\seealso{
\code{\link{glmnetr.compcv}} , \code{\link{summary.cv.stepreg}} , \code{\link{nested.glmnetr}}
}
