% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgbm_tuned_240202.R
\name{xgb.simple}
\alias{xgb.simple}
\title{Get a simple XGBoost model fit (no tuning)}
\usage{
xgb.simple(
  train.xgb.dat,
  booster = "gbtree",
  objective = "survival:cox",
  eval_metric = NULL,
  nfold = 5,
  seed = NULL,
  folds = NULL,
  minimize = NULL,
  nrounds = 1000
)
}
\arguments{
\item{train.xgb.dat}{The data to be used for training the XGBoost model}

\item{booster}{for now just "gbtree" (default)}

\item{objective}{one of "survival:cox" (default), "binary:logistic" or "reg:squarederror"}

\item{eval_metric}{one of "cox-nloglik" (default), "auc", "rmse" or NULL.  Default
of NULL will select an appropriate value based upon the objective value.}

\item{nfold}{number of folds used in xgb.cv() call}

\item{seed}{a seed for set.seed() to assure one can get the same results twice.  If NULL 
the program will generate a random seed.  Whether specified or NULL, the seed is stored in the output
object for future reference.}

\item{folds}{an optional list where each element is a vector of indeces for a 
test fold.  Default is NULL.  If specified then nfold is ignored a la xgb.cv().}

\item{minimize}{whether the eval_metric is to be minimized or maximized}

\item{nrounds}{max number of iterations}
}
\value{
an XGBoost model fit
}
\description{
This fits a gradient boosting machine model using the XGBoost
platform.  If uses a single set of hyperparameters that have sometimes been 
reasonable so runs very fast.  For a better fit one can use xgb.tuned()
which searches for a set of hyperparameters using the mlrMBO package
which will generally provide a better fit but take much longer.  See xgb.tuned()
for a description of the data format required for input.
}
\examples{
\donttest{
# Simulate some data for a Cox model 
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
Surv.xgb = ifelse( sim.data$event==1, sim.data$yt, -sim.data$yt )
data.full <- xgboost::xgb.DMatrix(data = sim.data$xs, label = Surv.xgb)
# for this example we use a small number for folds_n and nrounds to shorten run time 
xgbfit = xgb.simple( data.full, objective = "survival:cox", nfold=5, nrounds=20)
preds = predict(xgbfit, sim.data$xs)
summary( preds ) 
preds[1:8]
}

}
\author{
Walter K Kremers with contributions from Nicholas B Larson
}
