% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepreg_240322.R
\name{stepreg}
\alias{stepreg}
\title{Fit the steps of a stepwise regression.}
\usage{
stepreg(
  xs_st,
  start_time_st = NULL,
  y_st,
  event_st,
  steps_n = 0,
  method = "loglik",
  family = NULL,
  track = 0
)
}
\arguments{
\item{xs_st}{predictor input - an n by p matrix, where n (rows) is sample size, and p (columns) 
the number of predictors.  Must be in matrix form for complete data, no NA's, no Inf's, etc.,
and not a data frame.}

\item{start_time_st}{start time, Cox model only - class numeric of length same as number of patients (n)}

\item{y_st}{output vector: time, or stop time for Cox model, y_st 0 or 1 for binomal (logistic), numeric for gaussian. 
Must be a vector of length same as number of sample size.}

\item{event_st}{event_st indicator, 1 for event, 0 for census, Cox model only.
Must be a numeric vector of length same as sample size.}

\item{steps_n}{number of steps done in stepwise regression fitting}

\item{method}{method for choosing model in stepwise procedure, "loglik" or "concordance".
Other procedures use the "loglik".}

\item{family}{model family, "cox", "binomial" or "gaussian"}

\item{track}{1 to output stepwise fit program, 0 (default) to suppress}
}
\value{
does a stepwise regression of depth maximum depth steps_n
}
\description{
Fit the steps of a stepwise regression.
}
\examples{
set.seed(18306296)
sim.data=glmnetr.simdata(nrows=100, ncols=100, beta=c(0,1,1))
# this gives a more intersting case but takes longer to run
xs=sim.data$xs           
# this will work numerically
xs=sim.data$xs[,c(2,3,50:55)] 
y_=sim.data$yt  
event=sim.data$event
# for a Cox model 
cox.step.fit = stepreg(xs, NULL, y_, event, family="cox", steps_n=40) 
# ... and for a linear model 
y_=sim.data$yt  
norm.step.fit = stepreg(xs, NULL, y_, NULL, family="gaussian", steps_n=40) 

}
\seealso{
\code{\link{summary.stepreg}} , \code{\link{aicreg}} , \code{\link{cv.stepreg}} , \code{\link{nested.glmnetr}}
}
