% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm.R
\name{estequa.overglm}
\alias{estequa.overglm}
\title{Estimating Equations in Negative Binomial and Beta-Binomial Models}
\usage{
\method{estequa}{overglm}(model, ...)
}
\arguments{
\item{model}{an object of the class overglm which is obtained from the fit of a negative binomial or beta-binomial regression model.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector with the value of the estimating equations evaluated at the parameter estimates and the observed data.
}
\description{
Extracts estimating equations evaluated at the estimates of the parameters for a negative binomial or beta-binomial model fitted to the data.
}
\examples{
## Example 1
fit1 <- overglm(tumors ~ group, family="nb3(log)", data=mammary)
estequa(fit1)

fit2 <- overglm(infections ~ frequency + location, family="nb1(log)", data=swimmers)
estequa(fit2)

fit3 <- overglm(cbind(cells,200-cells) ~ tnf + ifn + tnf*ifn, family="bb(logit)", data=cellular)
estequa(fit3)

fit4 <- overglm(cbind(fetuses,litter-fetuses) ~ pht*tcpo, family="bb(logit)", data=ossification)
estequa(fit4)
}
