% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{QIC}
\alias{QIC}
\title{QIC for Generalized Estimating Equations}
\usage{
QIC(..., k = 2, u = FALSE, verbose = TRUE)
}
\arguments{
\item{...}{one or several objects of the class glmgee which are obtained from the fit of generalized estimating equations.}

\item{k}{an (optional) non-negative value giving the magnitude of the penalty. By default, \code{k} is set to be 2.}

\item{u}{an (optional) logical switch indicating if QIC should be replaced by QICu. By default, \code{u} is set to be FALSE.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
A \code{data.frame} with the values of -2*quasi-likelihood, the number of parameters in the linear predictor, and the value of QIC (or QICu if \code{u}=TRUE) for each glmgee object in the input.
}
\description{
Computes the quasi-likelihood under the independence model criterion (QIC) for one or more objects of the class glmgee.
}
\examples{
## Example 1
mod <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod, id=tree, family=Gamma("log"), data=spruces, corstr="Exchangeable")
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
QIC(fit1, fit2, fit3, fit4)

## Example 2
mod <- dep ~ visit + group
fit1 <- glmgee(mod, id=subj, family=gaussian, corstr="Exchangeable", data=depression)
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Non-Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
QIC(fit1, fit2, fit3, fit4)

## Example 3
mod <- depressd ~ visit + group
fit1 <- glmgee(mod, id=subj, family=binomial, corstr="Exchangeable", data=depression)
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
QIC(fit1, fit2, fit3, fit4)
}
\references{
Pan W. (2001) Akaike's information criterion in generalized estimating equations, \emph{Biometrics} 57, 120-125.

Hin L-Y, Carey V.J., Wang Y-G (2007) Criteria for Working–Correlation–Structure Selection in GEE:
Assessment via Simulation. \emph{The American Statistician} 61, 360–364.
}
\seealso{
\link{CIC}, \link{GHYC}, \link{RJC}, \link{AGPC}, \link{SGPC}
}
