% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown.R
\name{gloss_factory}
\alias{gloss_factory}
\title{Function factory to print glosses from dataframe}
\usage{
gloss_factory(
  glosses,
  use_conditionals = FALSE,
  id_column = "label",
  ignore_columns = NULL,
  validate = TRUE
)
}
\arguments{
\item{glosses}{Dataframe with gloss data.}

\item{use_conditionals}{Boolean. If \code{TRUE}, the returned function will use
conditional statements to filter the dataframe. Otherwise, it will use
ids and match them to the values in the \code{id_column}.}

\item{id_column}{Name of the column with ids for filtering, if \code{use_conditionals}
is \code{FALSE}.}

\item{ignore_columns}{Optional character vector with names of columns that could
be used for filtering but should not be provided to \code{\link[=gloss_df]{gloss_df()}}.}

\item{validate}{Boolean. If \code{TRUE}, running \code{\link[=gloss_factory]{gloss_factory()}} will print a few
informative messages about how glossr is reading the dataframe.}
}
\value{
A function.

If \code{use_conditionals} is \code{FALSE} (the default), the returned
function will take a character vector or a series of character vectors with
id's to filter. If \code{id_column} is "label", running that function will be
the equivalent to filtering \code{glosses} based on the values in the \code{label} column.

If \code{use_conditionals} is \code{TRUE}, the returned function will take the same
conditions that a \code{\link[dplyr:filter]{dplyr::filter()}} would.
}
\description{
This function takes a dataframe with glosses and returns another function
that takes either an id or list of ids (if \code{use_conditionals} is \code{FALSE})
or a conditional statement (if \code{TRUE}) and runs \code{\link[=gloss_df]{gloss_df()}} on the filtered
dataframe.
}
\examples{
my_glosses <- dplyr::select(glosses, -language)
by_label <- gloss_factory(my_glosses)

by_label("heartwarming-jp")

by_label("heartwarming-jp", "languid-jp")

by_cond <- gloss_factory(my_glosses, use_conditional = TRUE)
by_cond(stringr::str_ends(label, "jp"))
}
