% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived.traits.R
\name{ildt}
\alias{ildt}
\title{Derived traits for Glycan peaks in IgG for LCMS}
\usage{
ildt(data = NULL, method = "2014", print.exp.names = FALSE)
}
\arguments{
\item{data}{data frame that holds columns representing Glycans.}

\item{method}{year of the derived traits definition. By default 2014.}

\item{print.exp.names}{If \code{TRUE} return expected column names 
representing glycans.}
}
\value{
Returns the data frame with derived traits
}
\description{
Calcuates values of derived traits for Glycan peaks in IgG for LCMS
}
\details{
Calculates derived traits from basic glycan peaks. User can choose
which definition of the derived traits he will use
(see references for different versions/definitions of derived traits).
}
\author{
Ivo Ugrina
}
\references{
Jennifer E. Huffman et al. (2014)
"Comparative Performance of Four Methods for High-throughput Glycosylation Analysis of Immunoglobulin G in Genetic and Epidemiological Research*"
\url{http://dx.doi.org/10.1074/mcp.M113.037465}
}

