% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{refpeaknorm}
\alias{refpeaknorm}
\title{Reference Peak Normalization of glycan data}
\usage{
refpeaknorm(d, grouping = FALSE, peak = NULL)
}
\arguments{
\item{d}{data frame in long format containing glycan measurements}

\item{grouping}{should data be normalized per groups}

\item{peak}{glycan name to use as the reference peak. If \code{NULL}
peak with maximal value (summed through all samples) is used}
}
\value{
Returns a data.frame with original glycan values substituted by normalized ones
}
\description{
Returns glycans normalized with Reference Peak Normalization approach.
}
\details{
Input data frame should have at least the following three columns: \cr
  - gid - representing a unique name of a sample \cr
  - glycan - representing glycan names \cr
  - value - representing measured values \cr
and if the grouping argument is \code{TRUE} it should also have column: \cr
  - groups - representing groupings (e.g. IgG1, IgG2 and IgG4)
}
\examples{
data(mpiu)
mpiun <- refpeaknorm(mpiu)
head(mpiun)
}
\author{
Ivo Ugrina, Lucija Klarić
}

