% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{logratioVariogram}
\alias{logratioVariogram}
\title{Empirical logratio variogram calculation}
\usage{
logratioVariogram(data, ...)
}
\arguments{
\item{data}{a data container (of class "gmSpatialModel") or a composition (of class "acomp")}

\item{...}{extra arguments for generic functionality}
}
\value{
The output of this function depends on the number of \code{azimuth} values provided:
if it is one single value (or if you explicitly call \code{logratioVariogram.default}) the result is
a list of class "logratioVariogram" with the following elements
\itemize{
\item vg:	A nbins x D x D array containing the logratio variograms
\item h:	A nbins x D x D array containing the mean distance the value is computed on.
\item n:	A nbins x D x D array containing the number of nonmissing pairs used for the corresponding value.
If \code{azimuth} is a vector of directions, then the result is a matrix-like list of  "logratioVariogram" objects.
Each element of the mother list (or column of the matrix) is the variogram of one direction.
The output has a compound class c("logratioVariogramAnisotropy", "logratioVariogram").
}
}
\description{
Calculation of an empirical logratio variogram (aka variation-variogram)
}
\examples{
data("jura", package="gstat")
X = jura.pred[,1:2]
Zc = compositions::acomp(jura.pred[,7:13])
vg = logratioVariogram(data=Zc, loc=X)
class(vg)
summary(vg)
vg = logratioVariogram(data=Zc, loc=X, azimuth=c(0,90))
class(vg)
summary(vg)
}
