% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_missingness.R
\name{plot_missingness}
\alias{plot_missingness}
\title{Plot Missingness Mechanism and Boxplot}
\usage{
plot_missingness(
  dat,
  g,
  parlist,
  zm,
  bandwidth = 5,
  range.x = c(0, 5),
  ylim = NULL,
  kernel = "normal"
)
}
\arguments{
\item{dat}{An \eqn{n\times p} matrix where each row represents an individual observation}

\item{g}{Number of multivariate normal classes.}

\item{parlist}{A list containing the required parameters \eqn{(\pi, \mu, \Sigma)}.}

\item{zm}{An n-dimensional vector containing the class labels including the missing-label denoted as NA.}

\item{bandwidth}{Bandwidth for kernel smoothing. Default is 5.}

\item{range.x}{Range for x values. Default is c(0, 5).}

\item{ylim}{The y-axis limits in the form of c(ylim[1], ylim[2]). Default is NULL.}

\item{kernel}{Kernel type for smoothing. Default is 'normal'.}
}
\value{
A plot.
}
\description{
This function plots the smoothed values of `-log(entropy)` against the missingness mechanism
and a boxplot of entropy for labeled vs. unlabeled observations.
}
