% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R, R/printMethods.R
\name{LR_test}
\alias{LR_test}
\alias{print.lr}
\title{Perform likelihood ratio test for a GMVAR or SGMVAR model}
\usage{
LR_test(gmvar1, gmvar2)

\method{print}{lr}(x, ..., digits = 4)
}
\arguments{
\item{gmvar1}{an object of class \code{'gmvar'} generated by \code{fitGMVAR} or \code{GMVAR}, containing
the \strong{freely estimated} model.}

\item{gmvar2}{an object of class \code{'gmvar'} generated by \code{fitGMVAR} or \code{GMVAR}, containing
the \strong{constrained} model.}

\item{x}{object of class \code{'lr'} generated by the function \code{LR_test}.}

\item{...}{currently not used.}

\item{digits}{how many significant digits to print?}
}
\value{
Returns an object of class \eqn{'lr'} containing the test statistic and the related p-value.
}
\description{
\code{LR_test} performs a likelihood ratio test for a GMVAR or SGMVAR model
}
\details{
Performs a likelihood ratio test, testing the null hypothesis that the true parameter value lies
  in the constrained parameter space. Under the null, the test statistic is asymptotically
  \eqn{\chi^2}-distributed with \eqn{k} degrees of freedom, \eqn{k} being the difference in the dimensions
  of the unconstrained and constrained parameter spaces.

  Note that this function does \strong{not} verify that the two models are actually nested.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: print method
}}

\examples{
\donttest{
 # Load the data
 data(eurusd, package="gmvarkit")
 data <- cbind(10*eurusd[,1], 100*eurusd[,2])
 colnames(data) <- colnames(eurusd)

 # Structural GMVAR(2, 2), d=2 model identified similarly to Cholesky:
 W_222 <- matrix(c(1, NA, 0, 1), nrow=2, byrow=FALSE)
 fit222s <- fitGMVAR(data, p=2, M=2, structural_pars=list(W=W_222),
                     ncalls=1, seeds=4)

 # The same model but the AR coefficients restricted to be the same
 # in both regimes:
 C_mat <- rbind(diag(2*2^2), diag(2*2^2))
 fit222sc <- fitGMVAR(data, p=2, M=2, constraints=C_mat,
                      structural_pars=list(W=W_222),
                      ncalls=1, seeds=9)

 # Test the AR constraints with likelihood ratio test:
 LR_test(fit222s, fit222sc)
 }
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{Wald_test}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{cond_moment_plot}}
}
