% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{random_covmat}
\alias{random_covmat}
\title{Create random VAR model error term covariance matrix}
\usage{
random_covmat(d, M, omega_scale, W_scale, lambda_scale, structural_pars = NULL)
}
\arguments{
\item{d}{the number of time series in the system.}

\item{M}{\describe{
  \item{For \strong{GMVAR} and \strong{StMVAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMVAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMVAR type} components \code{M1} in the
   first element and \emph{StMVAR type} components \code{M2} in the second element. The total number of mixture components is \code{M=M1+M2}.}
}}

\item{omega_scale}{a size \eqn{(dx1)} strictly positive vector specifying the scale and variability of the
random covariance matrices in random mutations. The covariance matrices are drawn from (scaled) Wishart
distribution. Expected values of the random covariance matrices are \code{diag(omega_scale)}. Standard
deviations of the diagonal elements are \code{sqrt(2/d)*omega_scale[i]}
and for non-diagonal elements they are \code{sqrt(1/d*omega_scale[i]*omega_scale[j])}.
Note that for \code{d>4} this scale may need to be chosen carefully. Default in \code{GAfit} is
\code{var(stats::ar(data[,i], order.max=10)$resid, na.rm=TRUE), i=1,...,d}. This argument is ignored if
structural model is considered.}

\item{W_scale}{a size \eqn{(dx1)} strictly positive vector partly specifying the scale and variability of the
random covariance matrices in random mutations. The elements of the matrix \eqn{W} are drawn independently
from such normal distributions that the expectation of the main \strong{diagonal} elements of the first
regime's error term covariance matrix \eqn{\Omega_1 = WW'} is \code{W_scale}. The distribution of \eqn{\Omega_1}
will be in some sense like a Wishart distribution but with the columns (elements) of \eqn{W} obeying the given
constraints. The constraints are accounted for by setting the element to be always zero if it is subject to a zero
constraint and for sign constraints the absolute value or negative the absolute value are taken, and then the
variances of the elements of \eqn{W} are adjusted accordingly. This argument is ignored if reduced form model
is considered.}

\item{lambda_scale}{a length \eqn{M - 1} vector specifying the \strong{standard deviation} of the mean zero normal
  distribution from which the eigenvalue \eqn{\lambda_{mi}} parameters are drawn from in random mutations.
  As the eigenvalues should always be positive, the absolute value is taken. The elements of \code{lambda_scale}
  should be strictly positive real numbers with the \eqn{m-1}th element giving the degrees of freedom for the \eqn{m}th
  regime. The expected value of the main \strong{diagonal} elements \eqn{ij} of the \eqn{m}th \eqn{(m>1)} error term covariance
  matrix will be \code{W_scale[i]*(d - n_i)^(-1)*sum(lambdas*ind_fun)} where the \eqn{(d x 1)} vector \code{lambdas} is
  drawn from the absolute value of the t-distribution, \code{n_i} is the number of zero constraints in the \eqn{i}th
  row of \eqn{W} and \code{ind_fun} is an indicator function that takes the value one iff the \eqn{ij}th element of
  \eqn{W} is not constrained to zero. Basically, larger lambdas (or smaller degrees of freedom) imply larger variance.

  If the lambda parameters are \strong{constrained} with the \eqn{(d(M - 1) x r)} constraint matrix \eqn{C_lambda},
  then provide a length \eqn{r} vector specifying the standard deviation of the (absolute value of the) mean zero
  normal distribution each of the \eqn{\gamma} parameters are drawn from (the \eqn{\gamma} is a \eqn{(r x 1)} vector).
  The expected value of the main diagonal elements of the covariance matrices then depend on the constraints.

  This argument is ignored if \eqn{M==1} or a reduced form model is considered. Default is \code{rep(3, times=M-1)}
  if lambdas are not constrained and \code{rep(3, times=r)} if lambdas are constrained.

  As with omega_scale and W_scale, this argument should be adjusted carefully if specified by hand. \strong{NOTE}
  that if lambdas are constrained in some other way than restricting some of them to be identical, this parameter
  should be adjusted accordingly in order to the estimation succeed!}

\item{structural_pars}{If \code{NULL} a reduced form model is considered. For structural model, should be a list containing
the following elements:
\itemize{
  \item \code{W} - a \eqn{(dxd)} matrix with its entries imposing constraints on \eqn{W}: \code{NA} indicating that the element is
    unconstrained, a positive value indicating strict positive sign constraint, a negative value indicating strict
    negative sign constraint, and zero indicating that the element is constrained to zero.
  \item \code{C_lambda} - a \eqn{(d(M-1) x r)} constraint matrix that satisfies (\strong{\eqn{\lambda}}\eqn{_{2}}\eqn{,...,}
    \strong{\eqn{\lambda}}\eqn{_{M}) =} \strong{\eqn{C_{\lambda} \gamma}} where \strong{\eqn{\gamma}} is the new \eqn{(r x 1)}
    parameter subject to which the model is estimated (similarly to AR parameter constraints). The entries of \code{C_lambda}
    must be either \strong{positive} or \strong{zero}. Ignore (or set to \code{NULL}) if the eigenvalues \eqn{\lambda_{mi}}
    should not be constrained.
}
See Virolainen (2022) for the conditions required to identify the shocks and for the B-matrix as well (it is \eqn{W} times
a time-varying diagonal matrix with positive diagonal entries).}
}
\value{
\describe{
    \item{For \strong{reduced form models}:}{Returns a \eqn{(d(d+1)/2x1)} vector containing vech-vectorized covariance matrix
      \eqn{\Omega}.}
    \item{For \strong{structural models}:}{Returns a length \eqn{d^2 - n_zeros - d*(M - 1)} vector of the form
      \eqn{(Wvec(W),\lambda_2,...,\lambda_M)} where \eqn{\lambda_m=(\lambda_{m1},...,\lambda_{md})}
      contains the eigenvalue parameters of the \eqn{m}th regime \eqn{(m>1)} and \eqn{n_zeros} is the number of zero constraints
      in \eqn{W}. If lambdas are constrained, replacce \eqn{d*(M - 1)} in the length with \eqn{r} and
      \eqn{\lambda_2,...,\lambda_M)} with \strong{\eqn{\gamma}}. The operator \eqn{Wvec()} vectorizes a matrix and removes zeros.}
  }
}
\description{
\code{random_covmat} generates random VAR model \eqn{(dxd)} error term covariance matrix \eqn{\Omega}
  from (scaled) Wishart distribution for reduced form models and the parameters \eqn{W},\eqn{\lambda_1,...,\lambda_M}
  for structural models (from normal distributions).
}
\details{
Note that for StMVAR type regimes, the error term covariance matrix is consists of an ARCH type scalar that
  multiplies a constant covariance matrix. This function generates the constant covariance matrix part of the
  error term covariance matrix.
}
\keyword{internal}
