% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Env_interactions_all_vs_all.R
\name{pairwise_env_int.calc}
\alias{pairwise_env_int.calc}
\title{Pairwise environmental interaction effects}
\usage{
pairwise_env_int.calc(
  qt,
  g,
  env,
  round_imputed = FALSE,
  dominance_term = FALSE,
  square_env = FALSE,
  covariates = as.data.frame(matrix(0, nrow = 0, ncol = 0)),
  variant_names = paste(rep("variant", ncol(g)), as.character(1:ncol(g)), sep = "_"),
  env_names = paste(rep("env", ncol(env)), as.character(1:ncol(env)), sep = "_")
)
}
\arguments{
\item{qt}{A numeric vector}

\item{g}{A matrix, where each colomn represents a variant}

\item{env}{A matrix, where each row represents an environmental variable}

\item{round_imputed}{A boolian variable determining whether imputed genotype values should be rounded to the nearest integer in the analysis.}

\item{dominance_term}{A boolian variable determining whether a dominance term for the variant should be included as a covariates in the analysis}

\item{square_env}{A boolian variable determining whether the square of the environmental trait should be included as a covariate in the analysis}

\item{covariates}{A dataframe containing any other covariates that should be used; one column per covariate}

\item{variant_names}{A list of the names of the variants}

\item{env_names}{A list of the names of the environmental variables}
}
\value{
A dataframe with all possible variant-environmental pairs and their estimated interaction effect
}
\description{
Given a set of variants and environmental traits, and a single quantitative trait, this function calculates the interaction effect of all possible variant-environmental pairs
}
\examples{
g_vec <- matrix(0, nrow = 100000, ncol = 3)
freqs <- runif(ncol(g_vec), min = 0, max = 1)
env_vec <- matrix(0, nrow = 100000, ncol = 3)
for(i in 1:ncol(g_vec)){
 g_vec[, i] <- rbinom(100000, 2, freqs[i])
}
for( i in 1:ncol(env_vec)){
 env_vec[, i] <- round(runif(100000,min=0,max=6))
}

qt_vec <- rnorm(100000) + 0.1 * g_vec[, 1] + 0.2 *
          g_vec[, 2] -0.1 * env_vec[, 3] + 0.1 *
          env_vec[, 1] + 0.1 * g_vec[, 1] * env_vec[, 1]
res <- pairwise_env_int.calc(qt_vec, g_vec, env_vec)
}
