% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interactions_CaseControl_all_vs_all.R
\name{pairwise_int_CC.calc}
\alias{pairwise_int_CC.calc}
\title{Pairwise interaction effects for a case control variable}
\usage{
pairwise_int_CC.calc(
  cc,
  g,
  yob = rep(-1, length(cc)),
  sex = rep(-1, length(cc)),
  round_imputed = FALSE,
  dominance_terms = FALSE,
  covariates = as.data.frame(matrix(0, nrow = 0, ncol = 0)),
  variant_names = paste(rep("variant", ncol(g)), as.character(1:ncol(g)), sep = "_")
)
}
\arguments{
\item{cc}{A numeric vector}

\item{g}{A matrix, where each colomn represents a variant}

\item{yob}{A numerical vector containing year of birth. If some are unknown they should be marked as -1}

\item{sex}{A numerical vector containing sex, coded 0 for males, 1 for females and -1 for unknown}

\item{round_imputed}{A boolian variable determining whether imputed genotype values should be rounded to the nearest integer in the analysis.}

\item{dominance_terms}{A boolian variable determining whether dominance terms for the variants should be included as covariates in the analysis}

\item{covariates}{A dataframe containing any other covariates that should be used; one column per covariate}

\item{variant_names}{A list of the names of the variants}
}
\value{
A dataframe with all possible variant pairs and their estimated interaction effect
}
\description{
Given a set of variants and a case control variable, this function calculates the interaction effect of all possible variant-variant pairs
}
\examples{
N_run <- 25000
g_vec <- matrix(0, nrow = N_run, ncol = 5)
freqs <- runif(ncol(g_vec), min = 0,max = 1)
for(i in 1:ncol(g_vec)){
 g_vec[, i] <- rbinom(N_run, 2, freqs[i])
}
cc_vec <- rbinom(N_run,1,0.1 * (1.05 ^ g_vec[, 1]) *
          (1.06 ^ g_vec[,2]) * (0.95 ^ g_vec[, 3]) *
          (1.5^(g_vec[,1] * g_vec[,2])))
res <- pairwise_int_CC.calc(cc_vec, g_vec)
}
