% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnrflex.control.R
\name{gnrflex.control}
\alias{gnrflex.control}
\title{Control parameters in \code{gnrflex}}
\usage{
gnrflex.control(degree = 3, maxit = 100, reltol = 1e-5,
                       initial_step = 100, min_factor = 1e-5)
}
\arguments{
\item{degree}{degree of share regression polynomial. Defaults to 3.}

\item{maxit}{maximum number of iterations. Defaults to 100.}

\item{reltol}{relative convergence tolerance. Defaults to 1e-5.}

\item{initial_step}{a scaling parameter specifying the initial step-size factor used in each iteration of the Gauss-Newton algorithm. \code{initial_step} is halved in each convergence step.}

\item{min_factor}{the minimum value that the step-size factor can take on in the convergence step of any iteration of the Gauss-Newton algorithm.}
}
\value{
a list containing five elements: \code{degree}, \code{maxit}, \code{reltol}, \code{initial_step}, and \code{min_factor}.
}
\description{
Allows the user to modify convergence parameters of Gauss Newton algorithm used in the \code{\link[gnrprod]{gnrflex}} function.
}
