% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers_github.R
\name{cr_buildtrigger_repo}
\alias{cr_buildtrigger_repo}
\title{Create a buildtrigger repo object}
\usage{
cr_buildtrigger_repo(
  repo_name,
  branch = ".*",
  tag = NULL,
  type = c("github", "cloud_source"),
  github_secret = NULL,
  ...
)
}
\arguments{
\item{repo_name}{Either the GitHub username/repo_name or the Cloud Source repo_name}

\item{branch}{Regex of the branches that will trigger a build.  Ignore if tag is not NULL}

\item{tag}{Regex of tags that will trigger a build}

\item{type}{Whether trigger is GitHub or Cloud Source repoistory}

\item{github_secret}{If you need to pull from a private GitHub repo, add the github secret from Google Secret Manager which will be used via \link{cr_buildstep_secret}}

\item{...}{Other arguments passed to either \link{GitHubEventsConfig} or \link{RepoSource}}
}
\description{
Create a repository trigger object for use in build triggers
}
\seealso{
Other BuildTrigger functions: 
\code{\link{BuildTrigger}()},
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_run}()},
\code{\link{cr_buildtrigger}()}
}
\concept{BuildTrigger functions}
