#' Authenticate this session
#'
#' A wrapper for \link[googleAuthR]{gar_auth} and \link[googleAuthR]{gar_auth_service}
#'
#' @param new_user If TRUE, reauthenticate via Google login screen
#' @param no_auto Will ignore auto-authentication settings if TRUE
#'
#' @details
#'
#' If you have set the environment variable \code{GCS_AUTH_FILE} to a valid file location,
#'   the function will look there for authentication details.
#' Otherwise it will look in the working directory for the `.httr-oauth` file, which if not present
#'   will trigger an authentication flow via Google login screen in your browser.
#'
#' If \code{GCS_AUTH_FILE} is specified, then \code{gcs_auth()} will be called upon loading the package
#'   via \code{library(googleCloudStorageR)},
#'   meaning that calling this function yourself at the start of the session won't be necessary.
#'
#' \code{GCS_AUTH_FILE} can be either a token generated by \link[googleAuthR]{gar_auth} or
#'   service account JSON ending with file extension \code{.json}
#'
#' @return Invisibly, the token that has been saved to the session
#' @importFrom googleAuthR gar_auto_auth
#' @importFrom tools file_ext
#' @export
gcs_auth <- function(new_user = FALSE, no_auto = FALSE){

  required_scopes <- c("https://www.googleapis.com/auth/devstorage.full_control",
                       "https://www.googleapis.com/auth/devstorage.read_write",
                       "https://www.googleapis.com/auth/cloud-platform")

  gar_auto_auth(required_scopes,
                new_user = new_user,
                no_auto = no_auto,
                environment_var = "GCS_AUTH_FILE")
}
