% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_make.R
\name{request_make}
\alias{request_make}
\title{Make a Google Sheets API request}
\usage{
request_make(x, ...)
}
\arguments{
\item{x}{List. Holds the components for an HTTP request, presumably created
with \code{\link[=request_generate]{request_generate()}} or \code{\link[gargle:request_build]{gargle::request_build()}}. Must contain a
\code{method} and \code{url}. If present, \code{body} and \code{token} are used.}

\item{...}{Optional arguments passed through to the HTTP method.}
}
\value{
Object of class \code{response} from \link{httr}.
}
\description{
Low-level function to execute a Sheets API request. Most users
should, instead, use higher-level wrappers that facilitate common tasks,
such as reading or writing worksheets or cell ranges. The functions here
are intended for internal use and for programming around the Sheets API.

\code{make_request()} does very, very little: it calls an HTTP
method, only adding the googlesheets4 user agent. Typically the input has
been created with \code{\link[=request_generate]{request_generate()}} or \code{\link[gargle:request_build]{gargle::request_build()}} and the
output is processed with \code{process_response()}.
}
\seealso{
Other low-level API functions: 
\code{\link{request_generate}()},
\code{\link{sheets_has_token}()},
\code{\link{sheets_token}()}
}
\concept{low-level API functions}
