% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-dummy.R
\name{gpkg_create_dummy_features}
\alias{gpkg_create_dummy_features}
\title{Create a Dummy Feature Dataset in a GeoPackage}
\usage{
gpkg_create_dummy_features(x, table_name = "dummy_feature", values = NULL)
}
\arguments{
\item{x}{A \emph{geopackage} object}

\item{table_name}{A table name; default \code{"dummy_feature"}}

\item{values}{Values to use for new table. Defaults to default geometry name (\code{"geom"}), with generic \code{GEOMETRY} data type, with no spatial reference system.}
}
\value{
logical. \code{TRUE} on success.
}
\description{
This function creates a minimal (empty) feature table and \code{gpkg_geometry_columns} table entry.
}
\details{
This is a workaround so that \code{gpkg_vect()} (via \code{terra::vect()}) will recognize a GeoPackage as containing geometries and allow for use of OGR query utilities. The "dummy table" is not added to \code{gpkg_contents} and you should not try to use it for anything. The main purpose is to be able to use \code{gpkg_vect()} and \code{gpkg_ogr_query()} on a GeoPackage that contains only gridded and/or attribute data.
}
\seealso{
\code{\link[=gpkg_vect]{gpkg_vect()}} \code{\link[=gpkg_ogr_query]{gpkg_ogr_query()}}
}
